/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package panelgraph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;

/**
 *
 * @author Luca
 */
public class JGraphPanel extends JPanel {

    /** Il costruttore del pannello. */
    public JGraphPanel() {
        super();
        this.functions = new Vector();
        this.setBackground(Color.WHITE);
        // Bounds del dominio della funzione:
        this.bound_min_x = -360.0;
        this.bound_max_x =  360.0;
        this.bound_min_y = -2.0;
        this.bound_max_y =  2.0;
        // Parametri della griglia:
        this.setFunctions();
    }
    
    
    /** Il metodo serve per inserire i parametri della funzione. */
    private void setFunctions() {
        
        // Genero i punti della x:
        int numvalori = 1000;
        double[] x = new double[numvalori];
        double step = (this.bound_max_x - this.bound_min_x) / ((double)numvalori);
        x[0] = (float)this.bound_min_x;
        for(int i=1; i<numvalori-1; i++) {
            x[i] = x[i-1] + step;
        }
        x[numvalori-1] = this.bound_max_x;
        // Aggiungo le funzioni:
        AbstractFunction sinfunction = new SinFunction(x, Color.BLUE);
        this.functions.add(sinfunction);
        
        AbstractFunction cosfunction = new CosFunction(x, Color.RED);
        this.functions.add(cosfunction);
    }
    
    
    /** Il metodo esegue l'override del metodo paintComponent(). */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        
        // Disegno le funzioni:
        int width = this.getWidth();
        int height = this.getHeight();
        Iterator<AbstractFunction> iter = this.functions.iterator();
        while(iter.hasNext()) {
            AbstractFunction function = iter.next();
            function.render((Graphics2D)g, bound_min_x, bound_max_x, bound_min_y, bound_max_y, width, height);
        }
    }
    
    
    ////////////////////////////////////////////////////////////////////////////
    // Variabili private della classe:
    private Vector<AbstractFunction> functions;
        
    // Questi sono i limiti della funzione:
    private double bound_min_x;
    private double bound_max_x;
    private double bound_min_y;
    private double bound_max_y;
}
