library IEEE;
use IEEE.std_logic_1164.all;
library selfext;
use work.gates_pkg.all;
use work.fflop_pkg.all;

ENTITY s382_bench IS
  PORT (
    INP: in std_ulogic_vector(0 to 2);
    OUTP : out std_ulogic_vector(0 to 5);
    H : in std_ulogic
  );
END s382_bench ;

ARCHITECTURE structural OF s382_bench IS
  signal INTERP : std_ulogic_vector(0 to 172):=(others=>'0') ;
  signal OUTPI : std_ulogic_vector(OUTP'range):=(others=>'0') ;
BEGIN
  DFF0 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(1),
      H => H,
      Q => INTERP(0));

  DFF1 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(3),
      H => H,
      Q => INTERP(2));

  DFF2 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(5),
      H => H,
      Q => INTERP(4));

  DFF3 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(7),
      H => H,
      Q => INTERP(6));

  DFF4 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(9),
      H => H,
      Q => INTERP(8));

  DFF5 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(11),
      H => H,
      Q => INTERP(10));

  DFF6 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(13),
      H => H,
      Q => INTERP(12));

  DFF7 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(15),
      H => H,
      Q => INTERP(14));

  DFF8 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(17),
      H => H,
      Q => INTERP(16));

  DFF9 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(19),
      H => H,
      Q => INTERP(18));

  DFF10 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(21),
      H => H,
      Q => INTERP(20));

  DFF11 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(23),
      H => H,
      Q => INTERP(22));

  DFF12 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(25),
      H => H,
      Q => INTERP(24));

  DFF13 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(27),
      H => H,
      Q => INTERP(26));

  DFF14 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(29),
      H => H,
      Q => INTERP(28));

  DFF15 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(31),
      H => H,
      Q => INTERP(30));

  DFF16 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(33),
      H => H,
      Q => INTERP(32));

  DFF17 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(35),
      H => H,
      Q => INTERP(34));

  DFF18 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(37),
      H => H,
      Q => INTERP(36));

  DFF19 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(39),
      H => H,
      Q => INTERP(38));

  DFF20 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(41),
      H => H,
      Q => INTERP(40));

  INV0 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(0),
      out1 => INTERP(42));

  INV1 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(2),
      out1 => INTERP(43));

  INV2 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(6),
      out1 => INTERP(44));

  INV3 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(8),
      out1 => INTERP(45));

  INV4 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(18),
      out1 => INTERP(46));

  INV5 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(20),
      out1 => INTERP(47));

  INV6 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(22),
      out1 => INTERP(48));

  INV7 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(24),
      out1 => INTERP(49));

  INV8 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(26),
      out1 => INTERP(50));

  INV9 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(28),
      out1 => INTERP(51));

  INV10 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(30),
      out1 => INTERP(52));

  INV11 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(32),
      out1 => INTERP(53));

  INV12 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(34),
      out1 => INTERP(54));

  INV13 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(36),
      out1 => INTERP(55));

  INV14 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(38),
      out1 => INTERP(56));

  INV15 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(40),
      out1 => INTERP(57));

  INV16 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(0),
      out1 => INTERP(58));

  INV17 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(2),
      out1 => INTERP(59));

  INV18 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(2),
      out1 => INTERP(60));

  INV19 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(1),
      out1 => INTERP(61));

  INV20 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(24),
      out1 => INTERP(62));

  INV21 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(22),
      out1 => INTERP(63));

  INV22 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(20),
      out1 => INTERP(64));

  INV23 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(18),
      out1 => INTERP(65));

  INV24 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(40),
      out1 => INTERP(66));

  INV25 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(14),
      out1 => INTERP(67));

  INV26 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(12),
      out1 => INTERP(68));

  INV27 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(16),
      out1 => INTERP(69));

  INV28 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(10),
      out1 => INTERP(70));

  INV29 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(4),
      out1 => INTERP(71));

  INV30 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(58),
      out1 => INTERP(72));

  INV31 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(59),
      out1 => INTERP(73));

  INV32 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(61),
      out1 => INTERP(74));

  INV33 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(66),
      out1 => INTERP(75));

  INV34 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(57),
      out1 => INTERP(76));

  INV35 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(67),
      out1 => OUTPI(0));

  INV36 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(68),
      out1 => OUTPI(1));

  INV37 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(70),
      out1 => OUTPI(2));

  INV38 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(71),
      out1 => OUTPI(3));

  INV39 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(45),
      out1 => INTERP(77));

  INV40 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(44),
      out1 => INTERP(78));

  INV41 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(72),
      out1 => INTERP(79));

  INV42 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(73),
      out1 => INTERP(80));

  INV43 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(73),
      out1 => INTERP(81));

  INV44 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(73),
      out1 => INTERP(82));

  INV45 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(74),
      out1 => INTERP(83));

  INV46 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(77),
      out1 => OUTPI(4));

  INV47 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(78),
      out1 => OUTPI(5));

  INV48 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(85),
      out1 => INTERP(84));

  INV49 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(87),
      out1 => INTERP(86));

  INV50 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(89),
      out1 => INTERP(88));

  INV51 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(91),
      out1 => INTERP(90));

  INV52 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(93),
      out1 => INTERP(92));

  INV53 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(95),
      out1 => INTERP(94));

  INV54 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(95),
      out1 => INTERP(96));

  INV55 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(98),
      out1 => INTERP(97));

  INV56 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(88),
      out1 => INTERP(99));

  INV57 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(94),
      out1 => INTERP(17));

  INV58 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(101),
      out1 => INTERP(100));

  AND0 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(103),
      inp(1) => INTERP(16),
      out1 => INTERP(102));

  AND1 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(16),
      inp(1) => INTERP(82),
      out1 => INTERP(104));

  AND2 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(20),
      inp(1) => INTERP(82),
      out1 => INTERP(105));

  AND3 : ANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(24),
      inp(1) => INTERP(22),
      inp(2) => INTERP(82),
      out1 => INTERP(106));

  AND4 : ANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(62),
      inp(1) => INTERP(18),
      inp(2) => INTERP(82),
      out1 => INTERP(107));

  AND5 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(95),
      inp(1) => INTERP(51),
      out1 => INTERP(108));

  AND6 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(81),
      inp(1) => INTERP(90),
      out1 => INTERP(3));

  AND7 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(110),
      inp(1) => INTERP(51),
      out1 => INTERP(109));

  AND8 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(80),
      inp(1) => INTERP(92),
      out1 => INTERP(1));

  AND9 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(96),
      inp(1) => INTERP(110),
      out1 => INTERP(111));

  AND10 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(96),
      inp(1) => INTERP(113),
      out1 => INTERP(112));

  OR0 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(20),
      inp(1) => INTERP(18),
      inp(2) => INTERP(16),
      out1 => INTERP(114));

  OR1 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(24),
      inp(1) => INTERP(22),
      inp(2) => INTERP(60),
      out1 => INTERP(115));

  OR2 : ORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(62),
      inp(1) => INTERP(22),
      inp(2) => INTERP(20),
      inp(3) => INTERP(16),
      out1 => INTERP(116));

  OR3 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(65),
      inp(1) => INTERP(60),
      out1 => INTERP(117));

  OR4 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(72),
      inp(1) => INTERP(2),
      out1 => INTERP(118));

  OR5 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(64),
      inp(1) => INTERP(73),
      out1 => INTERP(119));

  OR6 : ORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(24),
      inp(1) => INTERP(22),
      inp(2) => INTERP(65),
      inp(3) => INTERP(73),
      out1 => INTERP(120));

  OR7 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(20),
      inp(1) => INTERP(65),
      inp(2) => INTERP(73),
      out1 => INTERP(121));

  OR8 : ORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(64),
      inp(1) => INTERP(18),
      inp(2) => INTERP(60),
      inp(3) => INTERP(73),
      out1 => INTERP(122));

  OR9 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(74),
      inp(1) => INTERP(0),
      out1 => INTERP(123));

  OR10 : ORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(125),
      inp(1) => INTERP(2),
      inp(2) => INTERP(18),
      inp(3) => INTERP(64),
      out1 => INTERP(124));

  OR11 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(126),
      inp(1) => INTERP(34),
      out1 => INTERP(87));

  OR12 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(128),
      inp(1) => INTERP(36),
      out1 => INTERP(127));

  OR13 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(76),
      inp(1) => INTERP(38),
      out1 => INTERP(129));

  OR14 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(79),
      inp(1) => INTERP(43),
      out1 => INTERP(130));

  OR15 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(83),
      inp(1) => INTERP(42),
      out1 => INTERP(131));

  OR16 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(132),
      inp(1) => INTERP(26),
      out1 => INTERP(98));

  OR17 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(134),
      inp(1) => INTERP(28),
      out1 => INTERP(133));

  OR18 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(136),
      inp(1) => INTERP(30),
      out1 => INTERP(135));

  OR19 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(84),
      inp(1) => INTERP(32),
      out1 => INTERP(137));

  OR20 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(138),
      inp(1) => INTERP(18),
      out1 => INTERP(101));

  OR21 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(140),
      inp(1) => INTERP(20),
      out1 => INTERP(139));

  OR22 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(142),
      inp(1) => INTERP(22),
      out1 => INTERP(141));

  OR23 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(99),
      inp(1) => INTERP(24),
      out1 => INTERP(143));

  NAND0 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(63),
      inp(1) => INTERP(24),
      out1 => INTERP(125));

  NAND1 : NANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(60),
      inp(1) => INTERP(65),
      inp(2) => INTERP(63),
      inp(3) => INTERP(24),
      out1 => INTERP(103));

  NAND2 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(128),
      inp(1) => INTERP(36),
      out1 => INTERP(144));

  NAND3 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(76),
      inp(1) => INTERP(38),
      out1 => INTERP(145));

  NAND4 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(119),
      inp(1) => INTERP(120),
      out1 => INTERP(113));

  NAND5 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(121),
      inp(1) => INTERP(122),
      out1 => INTERP(146));

  NAND6 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(148),
      inp(1) => INTERP(62),
      out1 => INTERP(147));

  NAND7 : NANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(82),
      inp(1) => INTERP(69),
      inp(2) => INTERP(64),
      inp(3) => INTERP(22),
      out1 => INTERP(149));

  NAND8 : NANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(82),
      inp(1) => INTERP(20),
      inp(2) => INTERP(117),
      inp(3) => INTERP(115),
      out1 => INTERP(150));

  NAND9 : NANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(82),
      inp(1) => INTERP(114),
      inp(2) => INTERP(116),
      out1 => INTERP(11));

  NAND10 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(152),
      inp(1) => INTERP(124),
      out1 => INTERP(151));

  NAND11 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(127),
      inp(1) => INTERP(144),
      out1 => INTERP(153));

  NAND12 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(129),
      inp(1) => INTERP(145),
      out1 => INTERP(154));

  NAND13 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(130),
      inp(1) => INTERP(118),
      out1 => INTERP(91));

  NAND14 : NANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(146),
      inp(1) => INTERP(63),
      inp(2) => INTERP(62),
      out1 => INTERP(155));

  NAND15 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(131),
      inp(1) => INTERP(123),
      out1 => INTERP(93));

  NAND16 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(151),
      inp(1) => INTERP(147),
      out1 => INTERP(95));

  NAND17 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(134),
      inp(1) => INTERP(28),
      out1 => INTERP(156));

  NAND18 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(136),
      inp(1) => INTERP(30),
      out1 => INTERP(157));

  NAND19 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(84),
      inp(1) => INTERP(32),
      out1 => INTERP(158));

  NAND20 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(151),
      inp(1) => INTERP(155),
      out1 => INTERP(110));

  NAND21 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(133),
      inp(1) => INTERP(156),
      out1 => INTERP(159));

  NAND22 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(135),
      inp(1) => INTERP(157),
      out1 => INTERP(160));

  NAND23 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(137),
      inp(1) => INTERP(158),
      out1 => INTERP(161));

  NAND24 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(140),
      inp(1) => INTERP(20),
      out1 => INTERP(162));

  NAND25 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(142),
      inp(1) => INTERP(22),
      out1 => INTERP(163));

  NAND26 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(99),
      inp(1) => INTERP(24),
      out1 => INTERP(164));

  NAND27 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(139),
      inp(1) => INTERP(162),
      out1 => INTERP(165));

  NAND28 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(141),
      inp(1) => INTERP(163),
      out1 => INTERP(166));

  NAND29 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(143),
      inp(1) => INTERP(164),
      out1 => INTERP(167));

  NOR0 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(20),
      inp(1) => INTERP(22),
      inp(2) => INTERP(24),
      out1 => INTERP(168));

  NOR1 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(36),
      inp(1) => INTERP(38),
      inp(2) => INTERP(40),
      out1 => INTERP(169));

  NOR2 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(28),
      inp(1) => INTERP(30),
      inp(2) => INTERP(32),
      out1 => INTERP(170));

  NOR3 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(169),
      inp(1) => INTERP(54),
      out1 => INTERP(171));

  NOR4 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(55),
      inp(1) => INTERP(56),
      inp(2) => INTERP(57),
      out1 => INTERP(126));

  NOR5 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(56),
      inp(1) => INTERP(57),
      out1 => INTERP(128));

  NOR6 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(69),
      out1 => INTERP(152));

  NOR7 : NORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(60),
      inp(2) => INTERP(64),
      inp(3) => INTERP(22),
      out1 => INTERP(148));

  NOR8 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(171),
      inp(1) => INTERP(0),
      out1 => INTERP(85));

  NOR9 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(75),
      inp(2) => INTERP(171),
      out1 => INTERP(41));

  NOR10 : NORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(85),
      inp(1) => INTERP(51),
      inp(2) => INTERP(52),
      inp(3) => INTERP(53),
      out1 => INTERP(132));

  NOR11 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(85),
      inp(1) => INTERP(52),
      inp(2) => INTERP(53),
      out1 => INTERP(134));

  NOR12 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(170),
      inp(1) => INTERP(85),
      inp(2) => INTERP(50),
      out1 => INTERP(89));

  NOR13 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(85),
      inp(1) => INTERP(53),
      out1 => INTERP(136));

  NOR14 : NORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(104),
      inp(1) => INTERP(105),
      inp(2) => INTERP(106),
      inp(3) => INTERP(107),
      out1 => INTERP(13));

  NOR15 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(149),
      inp(1) => INTERP(62),
      out1 => INTERP(5));

  NOR16 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(150),
      inp(1) => INTERP(102),
      out1 => INTERP(15));

  NOR17 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(86),
      inp(2) => INTERP(171),
      out1 => INTERP(35));

  NOR18 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(153),
      inp(2) => INTERP(171),
      out1 => INTERP(37));

  NOR19 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(154),
      inp(2) => INTERP(171),
      out1 => INTERP(39));

  NOR20 : NORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(88),
      inp(1) => INTERP(47),
      inp(2) => INTERP(48),
      inp(3) => INTERP(49),
      out1 => INTERP(138));

  NOR21 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(88),
      inp(1) => INTERP(48),
      inp(2) => INTERP(49),
      out1 => INTERP(140));

  NOR22 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(168),
      inp(1) => INTERP(88),
      inp(2) => INTERP(46),
      out1 => INTERP(172));

  NOR23 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(88),
      inp(1) => INTERP(49),
      out1 => INTERP(142));

  NOR24 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(97),
      inp(2) => INTERP(89),
      out1 => INTERP(27));

  NOR25 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(159),
      inp(2) => INTERP(89),
      out1 => INTERP(29));

  NOR26 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(160),
      inp(2) => INTERP(89),
      out1 => INTERP(31));

  NOR27 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(161),
      inp(2) => INTERP(89),
      out1 => INTERP(33));

  NOR28 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(111),
      inp(1) => INTERP(109),
      out1 => INTERP(7));

  NOR29 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(112),
      inp(1) => INTERP(108),
      out1 => INTERP(9));

  NOR30 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(100),
      inp(2) => INTERP(172),
      out1 => INTERP(19));

  NOR31 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(165),
      inp(2) => INTERP(172),
      out1 => INTERP(21));

  NOR32 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(166),
      inp(2) => INTERP(172),
      out1 => INTERP(23));

  NOR33 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(167),
      inp(2) => INTERP(172),
      out1 => INTERP(25));

  BUFFER_OUT : OUTP <= OUTPI;

END structural ;

ARCHITECTURE rtl OF s382_bench IS
  signal INTERP : std_ulogic_vector(0 to 172):=(others=>'0') ;
  signal OUTPI : std_ulogic_vector(OUTP'range):=(others=>'0') ;
BEGIN
  REGVECT : BLOCK (H='1' AND NOT H'STABLE)
    BEGIN
      DFF21 : INTERP(0) <= GUARDED INTERP(1) after 1 ns;
      DFF22 : INTERP(2) <= GUARDED INTERP(3) after 1 ns;
      DFF23 : INTERP(4) <= GUARDED INTERP(5) after 1 ns;
      DFF24 : INTERP(6) <= GUARDED INTERP(7) after 1 ns;
      DFF25 : INTERP(8) <= GUARDED INTERP(9) after 1 ns;
      DFF26 : INTERP(10) <= GUARDED INTERP(11) after 1 ns;
      DFF27 : INTERP(12) <= GUARDED INTERP(13) after 1 ns;
      DFF28 : INTERP(14) <= GUARDED INTERP(15) after 1 ns;
      DFF29 : INTERP(16) <= GUARDED INTERP(17) after 1 ns;
      DFF30 : INTERP(18) <= GUARDED INTERP(19) after 1 ns;
      DFF31 : INTERP(20) <= GUARDED INTERP(21) after 1 ns;
      DFF32 : INTERP(22) <= GUARDED INTERP(23) after 1 ns;
      DFF33 : INTERP(24) <= GUARDED INTERP(25) after 1 ns;
      DFF34 : INTERP(26) <= GUARDED INTERP(27) after 1 ns;
      DFF35 : INTERP(28) <= GUARDED INTERP(29) after 1 ns;
      DFF36 : INTERP(30) <= GUARDED INTERP(31) after 1 ns;
      DFF37 : INTERP(32) <= GUARDED INTERP(33) after 1 ns;
      DFF38 : INTERP(34) <= GUARDED INTERP(35) after 1 ns;
      DFF39 : INTERP(36) <= GUARDED INTERP(37) after 1 ns;
      DFF40 : INTERP(38) <= GUARDED INTERP(39) after 1 ns;
      DFF41 : INTERP(40) <= GUARDED INTERP(41) after 1 ns;
    END BLOCK ;
  INV59 : INTERP(42) <= NOT(fout,INTERP(0)) after 1 ns;
  INV60 : INTERP(43) <= NOT(fout,INTERP(2)) after 1 ns;
  INV61 : INTERP(44) <= NOT(fout,INTERP(6)) after 1 ns;
  INV62 : INTERP(45) <= NOT(fout,INTERP(8)) after 1 ns;
  INV63 : INTERP(46) <= NOT(fout,INTERP(18)) after 1 ns;
  INV64 : INTERP(47) <= NOT(fout,INTERP(20)) after 1 ns;
  INV65 : INTERP(48) <= NOT(fout,INTERP(22)) after 1 ns;
  INV66 : INTERP(49) <= NOT(fout,INTERP(24)) after 1 ns;
  INV67 : INTERP(50) <= NOT(fout,INTERP(26)) after 1 ns;
  INV68 : INTERP(51) <= NOT(fout,INTERP(28)) after 1 ns;
  INV69 : INTERP(52) <= NOT(fout,INTERP(30)) after 1 ns;
  INV70 : INTERP(53) <= NOT(fout,INTERP(32)) after 1 ns;
  INV71 : INTERP(54) <= NOT(fout,INTERP(34)) after 1 ns;
  INV72 : INTERP(55) <= NOT(fout,INTERP(36)) after 1 ns;
  INV73 : INTERP(56) <= NOT(fout,INTERP(38)) after 1 ns;
  INV74 : INTERP(57) <= NOT(fout,INTERP(40)) after 1 ns;
  INV75 : INTERP(58) <= NOT(fout,INP(0)) after 1 ns;
  INV76 : INTERP(59) <= NOT(fout,INP(2)) after 1 ns;
  INV77 : INTERP(60) <= NOT(fout,INTERP(2)) after 1 ns;
  INV78 : INTERP(61) <= NOT(fout,INP(1)) after 1 ns;
  INV79 : INTERP(62) <= NOT(fout,INTERP(24)) after 1 ns;
  INV80 : INTERP(63) <= NOT(fout,INTERP(22)) after 1 ns;
  INV81 : INTERP(64) <= NOT(fout,INTERP(20)) after 1 ns;
  INV82 : INTERP(65) <= NOT(fout,INTERP(18)) after 1 ns;
  INV83 : INTERP(66) <= NOT(fout,INTERP(40)) after 1 ns;
  INV84 : INTERP(67) <= NOT(fout,INTERP(14)) after 1 ns;
  INV85 : INTERP(68) <= NOT(fout,INTERP(12)) after 1 ns;
  INV86 : INTERP(69) <= NOT(fout,INTERP(16)) after 1 ns;
  INV87 : INTERP(70) <= NOT(fout,INTERP(10)) after 1 ns;
  INV88 : INTERP(71) <= NOT(fout,INTERP(4)) after 1 ns;
  INV89 : INTERP(72) <= NOT(fout,INTERP(58)) after 1 ns;
  INV90 : INTERP(73) <= NOT(fout,INTERP(59)) after 1 ns;
  INV91 : INTERP(74) <= NOT(fout,INTERP(61)) after 1 ns;
  INV92 : INTERP(75) <= NOT(fout,INTERP(66)) after 1 ns;
  INV93 : INTERP(76) <= NOT(fout,INTERP(57)) after 1 ns;
  INV94 : OUTPI(0) <= NOT(fout,INTERP(67)) after 1 ns;
  INV95 : OUTPI(1) <= NOT(fout,INTERP(68)) after 1 ns;
  INV96 : OUTPI(2) <= NOT(fout,INTERP(70)) after 1 ns;
  INV97 : OUTPI(3) <= NOT(fout,INTERP(71)) after 1 ns;
  INV98 : INTERP(77) <= NOT(fout,INTERP(45)) after 1 ns;
  INV99 : INTERP(78) <= NOT(fout,INTERP(44)) after 1 ns;
  INV100 : INTERP(79) <= NOT(fout,INTERP(72)) after 1 ns;
  INV101 : INTERP(80) <= NOT(fout,INTERP(73)) after 1 ns;
  INV102 : INTERP(81) <= NOT(fout,INTERP(73)) after 1 ns;
  INV103 : INTERP(82) <= NOT(fout,INTERP(73)) after 1 ns;
  INV104 : INTERP(83) <= NOT(fout,INTERP(74)) after 1 ns;
  INV105 : OUTPI(4) <= NOT(fout,INTERP(77)) after 1 ns;
  INV106 : OUTPI(5) <= NOT(fout,INTERP(78)) after 1 ns;
  INV107 : INTERP(84) <= NOT(fout,INTERP(85)) after 1 ns;
  INV108 : INTERP(86) <= NOT(fout,INTERP(87)) after 1 ns;
  INV109 : INTERP(88) <= NOT(fout,INTERP(89)) after 1 ns;
  INV110 : INTERP(90) <= NOT(fout,INTERP(91)) after 1 ns;
  INV111 : INTERP(92) <= NOT(fout,INTERP(93)) after 1 ns;
  INV112 : INTERP(94) <= NOT(fout,INTERP(95)) after 1 ns;
  INV113 : INTERP(96) <= NOT(fout,INTERP(95)) after 1 ns;
  INV114 : INTERP(97) <= NOT(fout,INTERP(98)) after 1 ns;
  INV115 : INTERP(99) <= NOT(fout,INTERP(88)) after 1 ns;
  INV116 : INTERP(17) <= NOT(fout,INTERP(94)) after 1 ns;
  INV117 : INTERP(100) <= NOT(fout,INTERP(101)) after 1 ns;
  AND11 : INTERP(102) <= INTERP(103) AND INTERP(16) after 1 ns;
  AND12 : INTERP(104) <= INTERP(16) AND INTERP(82) after 1 ns;
  AND13 : INTERP(105) <= INTERP(20) AND INTERP(82) after 1 ns;
  AND14 : INTERP(106) <= INTERP(24) AND INTERP(22) AND INTERP(82) after 1 ns;
  AND15 : INTERP(107) <= INTERP(62) AND INTERP(18) AND INTERP(82) after 1 ns;
  AND16 : INTERP(108) <= INTERP(95) AND INTERP(51) after 1 ns;
  AND17 : INTERP(3) <= INTERP(81) AND INTERP(90) after 1 ns;
  AND18 : INTERP(109) <= INTERP(110) AND INTERP(51) after 1 ns;
  AND19 : INTERP(1) <= INTERP(80) AND INTERP(92) after 1 ns;
  AND20 : INTERP(111) <= INTERP(96) AND INTERP(110) after 1 ns;
  AND21 : INTERP(112) <= INTERP(96) AND INTERP(113) after 1 ns;
  OR24 : INTERP(114) <= INTERP(20) OR INTERP(18) OR INTERP(16) after 1 ns;
  OR25 : INTERP(115) <= INTERP(24) OR INTERP(22) OR INTERP(60) after 1 ns;
  OR26 : INTERP(116) <= INTERP(62) OR INTERP(22) OR INTERP(20) OR INTERP(16) after 1 ns;
  OR27 : INTERP(117) <= INTERP(65) OR INTERP(60) after 1 ns;
  OR28 : INTERP(118) <= INTERP(72) OR INTERP(2) after 1 ns;
  OR29 : INTERP(119) <= INTERP(64) OR INTERP(73) after 1 ns;
  OR30 : INTERP(120) <= INTERP(24) OR INTERP(22) OR INTERP(65) OR INTERP(73) after 1 ns;
  OR31 : INTERP(121) <= INTERP(20) OR INTERP(65) OR INTERP(73) after 1 ns;
  OR32 : INTERP(122) <= INTERP(64) OR INTERP(18) OR INTERP(60) OR INTERP(73) after 1 ns;
  OR33 : INTERP(123) <= INTERP(74) OR INTERP(0) after 1 ns;
  OR34 : INTERP(124) <= INTERP(125) OR INTERP(2) OR INTERP(18) OR INTERP(64) after 1 ns;
  OR35 : INTERP(87) <= INTERP(126) OR INTERP(34) after 1 ns;
  OR36 : INTERP(127) <= INTERP(128) OR INTERP(36) after 1 ns;
  OR37 : INTERP(129) <= INTERP(76) OR INTERP(38) after 1 ns;
  OR38 : INTERP(130) <= INTERP(79) OR INTERP(43) after 1 ns;
  OR39 : INTERP(131) <= INTERP(83) OR INTERP(42) after 1 ns;
  OR40 : INTERP(98) <= INTERP(132) OR INTERP(26) after 1 ns;
  OR41 : INTERP(133) <= INTERP(134) OR INTERP(28) after 1 ns;
  OR42 : INTERP(135) <= INTERP(136) OR INTERP(30) after 1 ns;
  OR43 : INTERP(137) <= INTERP(84) OR INTERP(32) after 1 ns;
  OR44 : INTERP(101) <= INTERP(138) OR INTERP(18) after 1 ns;
  OR45 : INTERP(139) <= INTERP(140) OR INTERP(20) after 1 ns;
  OR46 : INTERP(141) <= INTERP(142) OR INTERP(22) after 1 ns;
  OR47 : INTERP(143) <= INTERP(99) OR INTERP(24) after 1 ns;
  NAND30 : INTERP(125) <= NOT(fout,INTERP(63) AND INTERP(24)) after 1 ns;
  NAND31 : INTERP(103) <= NOT(fout,INTERP(60) AND INTERP(65) AND INTERP(63) AND INTERP(24)) after 1 ns;
  NAND32 : INTERP(144) <= NOT(fout,INTERP(128) AND INTERP(36)) after 1 ns;
  NAND33 : INTERP(145) <= NOT(fout,INTERP(76) AND INTERP(38)) after 1 ns;
  NAND34 : INTERP(113) <= NOT(fout,INTERP(119) AND INTERP(120)) after 1 ns;
  NAND35 : INTERP(146) <= NOT(fout,INTERP(121) AND INTERP(122)) after 1 ns;
  NAND36 : INTERP(147) <= NOT(fout,INTERP(148) AND INTERP(62)) after 1 ns;
  NAND37 : INTERP(149) <= NOT(fout,INTERP(82) AND INTERP(69) AND INTERP(64) AND INTERP(22)) after 1 ns;
  NAND38 : INTERP(150) <= NOT(fout,INTERP(82) AND INTERP(20) AND INTERP(117) AND INTERP(115)) after 1 ns;
  NAND39 : INTERP(11) <= NOT(fout,INTERP(82) AND INTERP(114) AND INTERP(116)) after 1 ns;
  NAND40 : INTERP(151) <= NOT(fout,INTERP(152) AND INTERP(124)) after 1 ns;
  NAND41 : INTERP(153) <= NOT(fout,INTERP(127) AND INTERP(144)) after 1 ns;
  NAND42 : INTERP(154) <= NOT(fout,INTERP(129) AND INTERP(145)) after 1 ns;
  NAND43 : INTERP(91) <= NOT(fout,INTERP(130) AND INTERP(118)) after 1 ns;
  NAND44 : INTERP(155) <= NOT(fout,INTERP(146) AND INTERP(63) AND INTERP(62)) after 1 ns;
  NAND45 : INTERP(93) <= NOT(fout,INTERP(131) AND INTERP(123)) after 1 ns;
  NAND46 : INTERP(95) <= NOT(fout,INTERP(151) AND INTERP(147)) after 1 ns;
  NAND47 : INTERP(156) <= NOT(fout,INTERP(134) AND INTERP(28)) after 1 ns;
  NAND48 : INTERP(157) <= NOT(fout,INTERP(136) AND INTERP(30)) after 1 ns;
  NAND49 : INTERP(158) <= NOT(fout,INTERP(84) AND INTERP(32)) after 1 ns;
  NAND50 : INTERP(110) <= NOT(fout,INTERP(151) AND INTERP(155)) after 1 ns;
  NAND51 : INTERP(159) <= NOT(fout,INTERP(133) AND INTERP(156)) after 1 ns;
  NAND52 : INTERP(160) <= NOT(fout,INTERP(135) AND INTERP(157)) after 1 ns;
  NAND53 : INTERP(161) <= NOT(fout,INTERP(137) AND INTERP(158)) after 1 ns;
  NAND54 : INTERP(162) <= NOT(fout,INTERP(140) AND INTERP(20)) after 1 ns;
  NAND55 : INTERP(163) <= NOT(fout,INTERP(142) AND INTERP(22)) after 1 ns;
  NAND56 : INTERP(164) <= NOT(fout,INTERP(99) AND INTERP(24)) after 1 ns;
  NAND57 : INTERP(165) <= NOT(fout,INTERP(139) AND INTERP(162)) after 1 ns;
  NAND58 : INTERP(166) <= NOT(fout,INTERP(141) AND INTERP(163)) after 1 ns;
  NAND59 : INTERP(167) <= NOT(fout,INTERP(143) AND INTERP(164)) after 1 ns;
  NOR34 : INTERP(168) <= NOT(fout,INTERP(20) OR INTERP(22) OR INTERP(24)) after 1 ns;
  NOR35 : INTERP(169) <= NOT(fout,INTERP(36) OR INTERP(38) OR INTERP(40)) after 1 ns;
  NOR36 : INTERP(170) <= NOT(fout,INTERP(28) OR INTERP(30) OR INTERP(32)) after 1 ns;
  NOR37 : INTERP(171) <= NOT(fout,INTERP(169) OR INTERP(54)) after 1 ns;
  NOR38 : INTERP(126) <= NOT(fout,INTERP(55) OR INTERP(56) OR INTERP(57)) after 1 ns;
  NOR39 : INTERP(128) <= NOT(fout,INTERP(56) OR INTERP(57)) after 1 ns;
  NOR40 : INTERP(152) <= NOT(fout,INTERP(73) OR INTERP(69)) after 1 ns;
  NOR41 : INTERP(148) <= NOT(fout,INTERP(73) OR INTERP(60) OR INTERP(64) OR INTERP(22)) after 1 ns;
  NOR42 : INTERP(85) <= NOT(fout,INTERP(171) OR INTERP(0)) after 1 ns;
  NOR43 : INTERP(41) <= NOT(fout,INTERP(73) OR INTERP(75) OR INTERP(171)) after 1 ns;
  NOR44 : INTERP(132) <= NOT(fout,INTERP(85) OR INTERP(51) OR INTERP(52) OR INTERP(53)) after 1 ns;
  NOR45 : INTERP(134) <= NOT(fout,INTERP(85) OR INTERP(52) OR INTERP(53)) after 1 ns;
  NOR46 : INTERP(89) <= NOT(fout,INTERP(170) OR INTERP(85) OR INTERP(50)) after 1 ns;
  NOR47 : INTERP(136) <= NOT(fout,INTERP(85) OR INTERP(53)) after 1 ns;
  NOR48 : INTERP(13) <= NOT(fout,INTERP(104) OR INTERP(105) OR INTERP(106) OR INTERP(107)) after 1 ns;
  NOR49 : INTERP(5) <= NOT(fout,INTERP(149) OR INTERP(62)) after 1 ns;
  NOR50 : INTERP(15) <= NOT(fout,INTERP(150) OR INTERP(102)) after 1 ns;
  NOR51 : INTERP(35) <= NOT(fout,INTERP(73) OR INTERP(86) OR INTERP(171)) after 1 ns;
  NOR52 : INTERP(37) <= NOT(fout,INTERP(73) OR INTERP(153) OR INTERP(171)) after 1 ns;
  NOR53 : INTERP(39) <= NOT(fout,INTERP(73) OR INTERP(154) OR INTERP(171)) after 1 ns;
  NOR54 : INTERP(138) <= NOT(fout,INTERP(88) OR INTERP(47) OR INTERP(48) OR INTERP(49)) after 1 ns;
  NOR55 : INTERP(140) <= NOT(fout,INTERP(88) OR INTERP(48) OR INTERP(49)) after 1 ns;
  NOR56 : INTERP(172) <= NOT(fout,INTERP(168) OR INTERP(88) OR INTERP(46)) after 1 ns;
  NOR57 : INTERP(142) <= NOT(fout,INTERP(88) OR INTERP(49)) after 1 ns;
  NOR58 : INTERP(27) <= NOT(fout,INTERP(73) OR INTERP(97) OR INTERP(89)) after 1 ns;
  NOR59 : INTERP(29) <= NOT(fout,INTERP(73) OR INTERP(159) OR INTERP(89)) after 1 ns;
  NOR60 : INTERP(31) <= NOT(fout,INTERP(73) OR INTERP(160) OR INTERP(89)) after 1 ns;
  NOR61 : INTERP(33) <= NOT(fout,INTERP(73) OR INTERP(161) OR INTERP(89)) after 1 ns;
  NOR62 : INTERP(7) <= NOT(fout,INTERP(111) OR INTERP(109)) after 1 ns;
  NOR63 : INTERP(9) <= NOT(fout,INTERP(112) OR INTERP(108)) after 1 ns;
  NOR64 : INTERP(19) <= NOT(fout,INTERP(73) OR INTERP(100) OR INTERP(172)) after 1 ns;
  NOR65 : INTERP(21) <= NOT(fout,INTERP(73) OR INTERP(165) OR INTERP(172)) after 1 ns;
  NOR66 : INTERP(23) <= NOT(fout,INTERP(73) OR INTERP(166) OR INTERP(172)) after 1 ns;
  NOR67 : INTERP(25) <= NOT(fout,INTERP(73) OR INTERP(167) OR INTERP(172)) after 1 ns;
  BUFFER_OUT : OUTP <= OUTPI;

END rtl ;
