library IEEE;
use IEEE.std_logic_1164.all;
library selfext;
use work.gates_pkg.all;
use work.fflop_pkg.all;

ENTITY s27_bench IS
  PORT (
    INP: in std_ulogic_vector(0 to 3);
    OUTP : out std_ulogic_vector(0 to 0);
    H : in std_ulogic
  );
END s27_bench ;

ARCHITECTURE structural OF s27_bench IS
  signal INTERP : std_ulogic_vector(0 to 11):=(others=>'0') ;
  signal OUTPI : std_ulogic_vector(OUTP'range):=(others=>'0') ;
BEGIN
  DFF0 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(1),
      H => H,
      Q => INTERP(0));

  DFF1 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(3),
      H => H,
      Q => INTERP(2));

  DFF2 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(5),
      H => H,
      Q => INTERP(4));

  INV0 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(0),
      out1 => INTERP(6));

  INV1 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(3),
      out1 => OUTPI(0));

  AND0 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(6),
      inp(1) => INTERP(2),
      out1 => INTERP(7));

  OR0 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(9),
      inp(1) => INTERP(7),
      out1 => INTERP(8));

  OR1 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INP(3),
      inp(1) => INTERP(7),
      out1 => INTERP(10));

  NAND0 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(10),
      inp(1) => INTERP(8),
      out1 => INTERP(11));

  NOR0 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(6),
      inp(1) => INTERP(3),
      out1 => INTERP(1));

  NOR1 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(0),
      inp(1) => INTERP(11),
      out1 => INTERP(3));

  NOR2 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INP(1),
      inp(1) => INTERP(4),
      out1 => INTERP(9));

  NOR3 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INP(2),
      inp(1) => INTERP(9),
      out1 => INTERP(5));

  BUFFER_OUT : OUTP <= OUTPI;

END structural ;

ARCHITECTURE rtl OF s27_bench IS
  signal INTERP : std_ulogic_vector(0 to 11):=(others=>'0') ;
  signal OUTPI : std_ulogic_vector(OUTP'range):=(others=>'0') ;
BEGIN
  REGVECT : BLOCK (H='1' AND NOT H'STABLE)
    BEGIN
      DFF3 : INTERP(0) <= GUARDED INTERP(1) after 1 ns;
      DFF4 : INTERP(2) <= GUARDED INTERP(3) after 1 ns;
      DFF5 : INTERP(4) <= GUARDED INTERP(5) after 1 ns;
    END BLOCK ;
  INV2 : INTERP(6) <= NOT(fout,INP(0)) after 1 ns;
  INV3 : OUTPI(0) <= NOT(fout,INTERP(3)) after 1 ns;
  AND1 : INTERP(7) <= INTERP(6) AND INTERP(2) after 1 ns;
  OR2 : INTERP(8) <= INTERP(9) OR INTERP(7) after 1 ns;
  OR3 : INTERP(10) <= INP(3) OR INTERP(7) after 1 ns;
  NAND1 : INTERP(11) <= NOT(fout,INTERP(10) AND INTERP(8)) after 1 ns;
  NOR4 : INTERP(1) <= NOT(fout,INTERP(6) OR INTERP(3)) after 1 ns;
  NOR5 : INTERP(3) <= NOT(fout,INTERP(0) OR INTERP(11)) after 1 ns;
  NOR6 : INTERP(9) <= NOT(fout,INP(1) OR INTERP(4)) after 1 ns;
  NOR7 : INTERP(5) <= NOT(fout,INP(2) OR INTERP(9)) after 1 ns;
  BUFFER_OUT : OUTP <= OUTPI;

END rtl ;
