
-- PORTES DE BASE

------------------------------------------------------------------------
-- and gate
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity andg is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (in1, in2 : std_logic := '0';
          out1 : out std_logic := '0');               
end andg;

architecture only of andg is
begin

    p1: process(in1, in2)
        variable val,ex_value : std_logic := '0';
    begin
        val := in1 and in2;

        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;


------------------------------------------------------------------------
-- or gate
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity org is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (in1, in2 : std_logic := '0';
          out1 : out std_logic := '0');
end org;

architecture only of org is
begin

    p1: process(in1, in2)
        variable val,ex_value : std_logic := '0';
    begin
        val := in1 or in2;

        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;


------------------------------------------------------------------------
-- xor gate
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity xorg is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (in1, in2 : std_logic := '0';
          out1 : out std_logic := '0');
end xorg;

architecture only of xorg is
begin

    p1: process(in1, in2)
        variable val,ex_value : std_logic := '0';
    begin
        val := (in1 and not(in2)) or (not(in1) and in2);

        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;


------------------------------------------------------------------------
-- xnor gate
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity xnorg is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (in1, in2 : std_logic := '0';
          out1 : out std_logic := '0');

end xnorg;

architecture only of xnorg is
begin

    p1: process(in1, in2)
        variable val,ex_value : std_logic := '0';
    begin
        val := (not(in1) and not(in2)) or (in1 and in2);

        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;



------------------------------------------------------------------------
-- nand gate
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity nandg is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (in1, in2 : std_logic := '0';
          out1 : out std_logic := '0');

end nandg;

architecture only of nandg is
begin

    p1: process(in1, in2)
        variable val,ex_value : std_logic := '0';
    begin
        val := not(in1 and in2);

        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;



------------------------------------------------------------------------
-- nor gate
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity norg is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (in1, in2 : std_logic := '0';
          out1 : out std_logic := '0');

end norg;

architecture only of norg is
begin

    p1: process(in1, in2)
        variable val,ex_value : std_logic := '0';
    begin
        val := not(in1 or in2);

        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;


------------------------------------------------------------------------
-- inv gate
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity invg is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (in1: std_logic := '0';
          out1 : out std_logic := '0');

end invg;

architecture only of invg is
begin

    p1: process(in1)
        variable val,ex_value : std_logic := '0';

    begin
        val := not(in1);

        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;


------------------------------------------------------------------------
-- buff gate
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity buffg is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (in1: std_logic := '0';
          out1 : out std_logic := '0');

end buffg;

architecture only of buffg is
begin

    p1: process(in1)
        variable val,ex_value : std_logic := '0';

    begin
        val := in1;

        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;


--***************** PORTES GENERIQ0ES S0R LES ENTREES

------------------------------------------------------------------------
-- and gate generic on input number
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity andg_n is
    generic (n      : integer := 2;
             tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (inp : std_logic_vector(0 to n-1) := (others => '0');
          out1 : out std_logic := '0'
          );               
end andg_n;

architecture only of andg_n is
begin

    p1: process(inp)   
        variable val,ex_value : std_logic := '0';
    begin
        val:='1';
        for i in inp'range loop
          val := val and inp(i);
        end loop;
          
        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;


------------------------------------------------------------------------
-- nand gate generic on input number
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;


entity nandg_n is
    generic (n      : integer :=2;
             tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (inp : std_logic_vector(0 to n-1) := (others => '0');
          out1 : out std_logic := '0'
          );               
end nandg_n;

architecture only of nandg_n is
begin

    p1: process(inp)   
        variable val,ex_value : std_logic := '0';
    begin
        val:='1';
        for i in inp'range loop
          val := val and inp(i);
        end loop;
        val := not (val);
             
        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;


------------------------------------------------------------------------
-- or gate generic on input number
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity org_n is
    generic (n      : integer :=2;
             tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (inp : std_logic_vector(0 to n-1) := (others => '0');
          out1 : out std_logic := '0'
          );               
end org_n;

architecture only of org_n is
begin

    p1: process(inp)   
        variable val,ex_value : std_logic := '0';
    begin
        val:='0';
        for i in inp'range loop
          val := val or inp(i);
        end loop;
          
        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;



------------------------------------------------------------------------
-- nor gate generic on input number
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity norg_n is
    generic (n      : integer :=2;
             tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (inp : std_logic_vector(0 to n-1) := (others => '0');
          out1 : out std_logic := '0'
          );               
end norg_n;

architecture only of norg_n is
begin

    p1: process(inp)   
        variable val,ex_value : std_logic := '0';
    begin
        val:='0';
        for i in inp'range loop
          val := val or inp(i);
        end loop;
        val := not(val);
          
        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;



------------------------------------------------------------------------
-- xor gate generic on input number
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity xorg_n is
    generic (n      : integer :=2;
             tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (inp : std_logic_vector(0 to n-1) := (others => '0');
          out1 : out std_logic := '0'
          );               
end xorg_n;

architecture only of xorg_n is
begin

    p1: process(inp)   
        variable val,ex_value : std_logic := '0';
    begin
        val:='0';
        for i in inp'range loop
          val := (val and not(inp(i))) or (not(val) and inp(i));
        end loop;
          
        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;




------------------------------------------------------------------------
-- xnor gate generic on input number
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity xnorg_n is
    generic (n      : integer :=2;
             tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (inp : std_logic_vector(0 to n-1) := (others => '0');
          out1 : out std_logic := '0'
          );               
end xnorg_n;

architecture only of xnorg_n is
begin

    p1: process(inp)   
        variable val,ex_value : std_logic := '0';
    begin
        val:='0';
        for i in inp'range loop
          val := (val and not(inp(i))) or (not(val) and inp(i));
        end loop;
        val := not(val);
          
        if val /= ex_value then
          ex_value := val;
          case val is 
            when '0' =>
                out1 <= val after tpd_hl;
            when '1' =>
                out1 <= val after tpd_lh;
            when others =>
          end case;
        end if;  
    end process;

end only;

