library IEEE;
use IEEE.std_logic_1164.all;
library selfext;
use work.gates_pkg.all;
use work.fflop_pkg.all;

ENTITY s208_1_bench IS
  PORT (
    INP: in std_ulogic_vector(0 to 9);
    OUTP : out std_ulogic_vector(0 to 0);
    H : in std_ulogic
  );
END s208_1_bench ;

ARCHITECTURE structural OF s208_1_bench IS
  signal INTERP : std_ulogic_vector(0 to 110):=(others=>'0') ;
  signal OUTPI : std_ulogic_vector(OUTP'range):=(others=>'0') ;
BEGIN
  DFF0 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(1),
      H => H,
      Q => INTERP(0));

  DFF1 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(3),
      H => H,
      Q => INTERP(2));

  DFF2 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(5),
      H => H,
      Q => INTERP(4));

  DFF3 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(7),
      H => H,
      Q => INTERP(6));

  DFF4 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(9),
      H => H,
      Q => INTERP(8));

  DFF5 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(11),
      H => H,
      Q => INTERP(10));

  DFF6 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(13),
      H => H,
      Q => INTERP(12));

  DFF7 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(15),
      H => H,
      Q => INTERP(14));

  INV0 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(17),
      out1 => INTERP(16));

  INV1 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(2),
      out1 => INTERP(18));

  INV2 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(20),
      out1 => INTERP(19));

  INV3 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(4),
      out1 => INTERP(21));

  INV4 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(6),
      out1 => INTERP(22));

  INV5 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(0),
      out1 => INTERP(23));

  INV6 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(0),
      out1 => INTERP(24));

  INV7 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(0),
      out1 => INTERP(25));

  INV8 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(2),
      out1 => INTERP(26));

  INV9 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(17),
      out1 => INTERP(27));

  INV10 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(29),
      out1 => INTERP(28));

  INV11 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(12),
      out1 => INTERP(30));

  INV12 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(14),
      out1 => INTERP(31));

  INV13 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(33),
      out1 => INTERP(32));

  INV14 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(10),
      out1 => INTERP(34));

  INV15 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(12),
      out1 => INTERP(35));

  INV16 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(37),
      out1 => INTERP(36));

  INV17 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(29),
      out1 => INTERP(38));

  INV18 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(0),
      out1 => INTERP(39));

  INV19 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(6),
      out1 => INTERP(40));

  INV20 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(4),
      out1 => INTERP(41));

  INV21 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(2),
      out1 => INTERP(42));

  INV22 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(0),
      out1 => INTERP(43));

  INV23 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(45),
      out1 => INTERP(44));

  INV24 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(0),
      out1 => INTERP(46));

  INV25 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(14),
      out1 => INTERP(47));

  INV26 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(12),
      out1 => INTERP(48));

  INV27 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(10),
      out1 => INTERP(49));

  INV28 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(8),
      out1 => INTERP(50));

  INV29 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(52),
      out1 => INTERP(51));

  INV30 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(54),
      out1 => INTERP(53));

  INV31 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(56),
      out1 => INTERP(55));

  INV32 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(7),
      out1 => INTERP(57));

  INV33 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(6),
      out1 => INTERP(58));

  INV34 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(60),
      out1 => INTERP(59));

  INV35 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(62),
      out1 => INTERP(61));

  INV36 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(3),
      out1 => INTERP(63));

  INV37 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(2),
      out1 => INTERP(64));

  AND0 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(17),
      inp(1) => INTERP(18),
      out1 => INTERP(65));

  AND1 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(2),
      inp(1) => INTERP(16),
      out1 => INTERP(66));

  AND2 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(20),
      inp(1) => INTERP(21),
      out1 => INTERP(67));

  AND3 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(4),
      inp(1) => INTERP(19),
      out1 => INTERP(68));

  AND4 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(6),
      inp(1) => INTERP(23),
      out1 => INTERP(69));

  AND5 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INP(0),
      inp(1) => INTERP(22),
      out1 => INTERP(70));

  AND6 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(29),
      inp(1) => INTERP(30),
      out1 => INTERP(71));

  AND7 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(12),
      inp(1) => INTERP(28),
      out1 => INTERP(72));

  AND8 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(14),
      inp(1) => INTERP(32),
      out1 => INTERP(73));

  AND9 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(33),
      inp(1) => INTERP(31),
      out1 => INTERP(74));

  AND10 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(38),
      inp(1) => INTERP(12),
      out1 => INTERP(75));

  AND11 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(76),
      inp(1) => INP(0),
      out1 => INTERP(33));

  AND12 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(78),
      inp(1) => INTERP(79),
      out1 => INTERP(77));

  AND13 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(78),
      inp(1) => INTERP(80),
      out1 => INTERP(60));

  AND14 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(78),
      inp(1) => INTERP(81),
      out1 => INTERP(62));

  AND15 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(78),
      inp(1) => INTERP(83),
      out1 => INTERP(82));

  AND16 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(85),
      inp(1) => INP(8),
      out1 => INTERP(84));

  AND17 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INP(0),
      inp(1) => INP(9),
      out1 => INTERP(86));

  AND18 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(77),
      inp(1) => INP(4),
      out1 => INTERP(87));

  AND19 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(89),
      inp(1) => INP(5),
      out1 => INTERP(88));

  AND20 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(82),
      inp(1) => INP(1),
      out1 => INTERP(90));

  OR0 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(27),
      inp(1) => INTERP(0),
      inp(2) => INTERP(26),
      out1 => INTERP(91));

  OR1 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(65),
      inp(1) => INTERP(66),
      out1 => INTERP(3));

  OR2 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(69),
      inp(1) => INTERP(70),
      out1 => INTERP(7));

  OR3 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(93),
      inp(1) => INTERP(26),
      inp(2) => INTERP(24),
      out1 => INTERP(92));

  OR4 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(95),
      inp(1) => INTERP(8),
      inp(2) => INTERP(34),
      out1 => INTERP(94));

  OR5 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(95),
      inp(1) => INTERP(10),
      out1 => INTERP(96));

  OR6 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(73),
      inp(1) => INTERP(74),
      out1 => INTERP(15));

  OR7 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(29),
      inp(1) => INTERP(35),
      inp(2) => INTERP(34),
      out1 => INTERP(97));

  OR8 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(55),
      inp(1) => INTERP(58),
      out1 => INTERP(98));

  OR9 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(53),
      inp(1) => INTERP(57),
      out1 => INTERP(99));

  OR10 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(61),
      inp(1) => INTERP(64),
      out1 => INTERP(100));

  OR11 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(59),
      inp(1) => INTERP(63),
      out1 => INTERP(101));

  OR12 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(103),
      inp(1) => INTERP(104),
      out1 => INTERP(102));

  OR13 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(102),
      inp(1) => INTERP(90),
      out1 => OUTPI(0));

  NAND0 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(91),
      inp(1) => INTERP(105),
      out1 => INTERP(1));

  NAND1 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(92),
      inp(1) => INTERP(0),
      out1 => INTERP(105));

  NAND2 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(6),
      inp(1) => INTERP(4),
      out1 => INTERP(93));

  NAND3 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(6),
      inp(1) => INP(0),
      out1 => INTERP(20));

  NAND4 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(94),
      inp(1) => INTERP(106),
      out1 => INTERP(9));

  NAND5 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(96),
      inp(1) => INTERP(36),
      out1 => INTERP(11));

  NAND6 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(97),
      inp(1) => INTERP(8),
      out1 => INTERP(106));

  NAND7 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(14),
      inp(1) => INTERP(33),
      out1 => INTERP(29));

  NAND8 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(38),
      inp(1) => INTERP(12),
      out1 => INTERP(95));

  NAND9 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(44),
      inp(1) => INTERP(41),
      out1 => INTERP(107));

  NAND10 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(40),
      inp(1) => INP(0),
      out1 => INTERP(45));

  NAND11 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(51),
      inp(1) => INTERP(48),
      out1 => INTERP(108));

  NAND12 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(47),
      inp(1) => INP(0),
      out1 => INTERP(52));

  NAND13 : NANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(98),
      inp(1) => INTERP(99),
      inp(2) => INTERP(109),
      out1 => INTERP(103));

  NAND14 : NANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(100),
      inp(1) => INTERP(101),
      inp(2) => INTERP(110),
      out1 => INTERP(104));

  NOR0 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(67),
      inp(1) => INTERP(68),
      out1 => INTERP(5));

  NOR1 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(93),
      inp(1) => INTERP(25),
      inp(2) => INTERP(26),
      out1 => INTERP(76));

  NOR2 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(93),
      inp(1) => INTERP(24),
      out1 => INTERP(17));

  NOR3 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(71),
      inp(1) => INTERP(72),
      out1 => INTERP(13));

  NOR4 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(34),
      inp(1) => INTERP(75),
      out1 => INTERP(37));

  NOR5 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(39),
      inp(1) => INTERP(40),
      out1 => INTERP(85));

  NOR6 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(41),
      inp(1) => INTERP(45),
      out1 => INTERP(54));

  NOR7 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(42),
      inp(1) => INTERP(107),
      out1 => INTERP(56));

  NOR8 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(2),
      inp(1) => INTERP(107),
      inp(2) => INTERP(43),
      out1 => INTERP(89));

  NOR9 : NORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(0),
      inp(1) => INTERP(4),
      inp(2) => INTERP(2),
      inp(3) => INTERP(6),
      out1 => INTERP(78));

  NOR10 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(46),
      inp(1) => INTERP(47),
      out1 => INTERP(79));

  NOR11 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(48),
      inp(1) => INTERP(52),
      out1 => INTERP(80));

  NOR12 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(49),
      inp(1) => INTERP(108),
      out1 => INTERP(81));

  NOR13 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(10),
      inp(1) => INTERP(108),
      inp(2) => INTERP(50),
      out1 => INTERP(83));

  NOR14 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(84),
      inp(1) => INTERP(86),
      out1 => INTERP(109));

  NOR15 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(87),
      inp(1) => INTERP(88),
      out1 => INTERP(110));

  BUFFER_OUT : OUTP <= OUTPI;

END structural ;

ARCHITECTURE rtl OF s208_1_bench IS
  signal INTERP : std_ulogic_vector(0 to 110):=(others=>'0') ;
  signal OUTPI : std_ulogic_vector(OUTP'range):=(others=>'0') ;
BEGIN
  REGVECT : BLOCK (H='1' AND NOT H'STABLE)
    BEGIN
      DFF8 : INTERP(0) <= GUARDED INTERP(1) after 1 ns;
      DFF9 : INTERP(2) <= GUARDED INTERP(3) after 1 ns;
      DFF10 : INTERP(4) <= GUARDED INTERP(5) after 1 ns;
      DFF11 : INTERP(6) <= GUARDED INTERP(7) after 1 ns;
      DFF12 : INTERP(8) <= GUARDED INTERP(9) after 1 ns;
      DFF13 : INTERP(10) <= GUARDED INTERP(11) after 1 ns;
      DFF14 : INTERP(12) <= GUARDED INTERP(13) after 1 ns;
      DFF15 : INTERP(14) <= GUARDED INTERP(15) after 1 ns;
    END BLOCK ;
  INV38 : INTERP(16) <= NOT(fout,INTERP(17)) after 1 ns;
  INV39 : INTERP(18) <= NOT(fout,INTERP(2)) after 1 ns;
  INV40 : INTERP(19) <= NOT(fout,INTERP(20)) after 1 ns;
  INV41 : INTERP(21) <= NOT(fout,INTERP(4)) after 1 ns;
  INV42 : INTERP(22) <= NOT(fout,INTERP(6)) after 1 ns;
  INV43 : INTERP(23) <= NOT(fout,INP(0)) after 1 ns;
  INV44 : INTERP(24) <= NOT(fout,INP(0)) after 1 ns;
  INV45 : INTERP(25) <= NOT(fout,INTERP(0)) after 1 ns;
  INV46 : INTERP(26) <= NOT(fout,INTERP(2)) after 1 ns;
  INV47 : INTERP(27) <= NOT(fout,INTERP(17)) after 1 ns;
  INV48 : INTERP(28) <= NOT(fout,INTERP(29)) after 1 ns;
  INV49 : INTERP(30) <= NOT(fout,INTERP(12)) after 1 ns;
  INV50 : INTERP(31) <= NOT(fout,INTERP(14)) after 1 ns;
  INV51 : INTERP(32) <= NOT(fout,INTERP(33)) after 1 ns;
  INV52 : INTERP(34) <= NOT(fout,INTERP(10)) after 1 ns;
  INV53 : INTERP(35) <= NOT(fout,INTERP(12)) after 1 ns;
  INV54 : INTERP(36) <= NOT(fout,INTERP(37)) after 1 ns;
  INV55 : INTERP(38) <= NOT(fout,INTERP(29)) after 1 ns;
  INV56 : INTERP(39) <= NOT(fout,INP(0)) after 1 ns;
  INV57 : INTERP(40) <= NOT(fout,INTERP(6)) after 1 ns;
  INV58 : INTERP(41) <= NOT(fout,INTERP(4)) after 1 ns;
  INV59 : INTERP(42) <= NOT(fout,INTERP(2)) after 1 ns;
  INV60 : INTERP(43) <= NOT(fout,INTERP(0)) after 1 ns;
  INV61 : INTERP(44) <= NOT(fout,INTERP(45)) after 1 ns;
  INV62 : INTERP(46) <= NOT(fout,INP(0)) after 1 ns;
  INV63 : INTERP(47) <= NOT(fout,INTERP(14)) after 1 ns;
  INV64 : INTERP(48) <= NOT(fout,INTERP(12)) after 1 ns;
  INV65 : INTERP(49) <= NOT(fout,INTERP(10)) after 1 ns;
  INV66 : INTERP(50) <= NOT(fout,INTERP(8)) after 1 ns;
  INV67 : INTERP(51) <= NOT(fout,INTERP(52)) after 1 ns;
  INV68 : INTERP(53) <= NOT(fout,INTERP(54)) after 1 ns;
  INV69 : INTERP(55) <= NOT(fout,INTERP(56)) after 1 ns;
  INV70 : INTERP(57) <= NOT(fout,INP(7)) after 1 ns;
  INV71 : INTERP(58) <= NOT(fout,INP(6)) after 1 ns;
  INV72 : INTERP(59) <= NOT(fout,INTERP(60)) after 1 ns;
  INV73 : INTERP(61) <= NOT(fout,INTERP(62)) after 1 ns;
  INV74 : INTERP(63) <= NOT(fout,INP(3)) after 1 ns;
  INV75 : INTERP(64) <= NOT(fout,INP(2)) after 1 ns;
  AND21 : INTERP(65) <= INTERP(17) AND INTERP(18) after 1 ns;
  AND22 : INTERP(66) <= INTERP(2) AND INTERP(16) after 1 ns;
  AND23 : INTERP(67) <= INTERP(20) AND INTERP(21) after 1 ns;
  AND24 : INTERP(68) <= INTERP(4) AND INTERP(19) after 1 ns;
  AND25 : INTERP(69) <= INTERP(6) AND INTERP(23) after 1 ns;
  AND26 : INTERP(70) <= INP(0) AND INTERP(22) after 1 ns;
  AND27 : INTERP(71) <= INTERP(29) AND INTERP(30) after 1 ns;
  AND28 : INTERP(72) <= INTERP(12) AND INTERP(28) after 1 ns;
  AND29 : INTERP(73) <= INTERP(14) AND INTERP(32) after 1 ns;
  AND30 : INTERP(74) <= INTERP(33) AND INTERP(31) after 1 ns;
  AND31 : INTERP(75) <= INTERP(38) AND INTERP(12) after 1 ns;
  AND32 : INTERP(33) <= INTERP(76) AND INP(0) after 1 ns;
  AND33 : INTERP(77) <= INTERP(78) AND INTERP(79) after 1 ns;
  AND34 : INTERP(60) <= INTERP(78) AND INTERP(80) after 1 ns;
  AND35 : INTERP(62) <= INTERP(78) AND INTERP(81) after 1 ns;
  AND36 : INTERP(82) <= INTERP(78) AND INTERP(83) after 1 ns;
  AND37 : INTERP(84) <= INTERP(85) AND INP(8) after 1 ns;
  AND38 : INTERP(86) <= INP(0) AND INP(9) after 1 ns;
  AND39 : INTERP(87) <= INTERP(77) AND INP(4) after 1 ns;
  AND40 : INTERP(88) <= INTERP(89) AND INP(5) after 1 ns;
  AND41 : INTERP(90) <= INTERP(82) AND INP(1) after 1 ns;
  OR14 : INTERP(91) <= INTERP(27) OR INTERP(0) OR INTERP(26) after 1 ns;
  OR15 : INTERP(3) <= INTERP(65) OR INTERP(66) after 1 ns;
  OR16 : INTERP(7) <= INTERP(69) OR INTERP(70) after 1 ns;
  OR17 : INTERP(92) <= INTERP(93) OR INTERP(26) OR INTERP(24) after 1 ns;
  OR18 : INTERP(94) <= INTERP(95) OR INTERP(8) OR INTERP(34) after 1 ns;
  OR19 : INTERP(96) <= INTERP(95) OR INTERP(10) after 1 ns;
  OR20 : INTERP(15) <= INTERP(73) OR INTERP(74) after 1 ns;
  OR21 : INTERP(97) <= INTERP(29) OR INTERP(35) OR INTERP(34) after 1 ns;
  OR22 : INTERP(98) <= INTERP(55) OR INTERP(58) after 1 ns;
  OR23 : INTERP(99) <= INTERP(53) OR INTERP(57) after 1 ns;
  OR24 : INTERP(100) <= INTERP(61) OR INTERP(64) after 1 ns;
  OR25 : INTERP(101) <= INTERP(59) OR INTERP(63) after 1 ns;
  OR26 : INTERP(102) <= INTERP(103) OR INTERP(104) after 1 ns;
  OR27 : OUTPI(0) <= INTERP(102) OR INTERP(90) after 1 ns;
  NAND15 : INTERP(1) <= NOT(fout,INTERP(91) AND INTERP(105)) after 1 ns;
  NAND16 : INTERP(105) <= NOT(fout,INTERP(92) AND INTERP(0)) after 1 ns;
  NAND17 : INTERP(93) <= NOT(fout,INTERP(6) AND INTERP(4)) after 1 ns;
  NAND18 : INTERP(20) <= NOT(fout,INTERP(6) AND INP(0)) after 1 ns;
  NAND19 : INTERP(9) <= NOT(fout,INTERP(94) AND INTERP(106)) after 1 ns;
  NAND20 : INTERP(11) <= NOT(fout,INTERP(96) AND INTERP(36)) after 1 ns;
  NAND21 : INTERP(106) <= NOT(fout,INTERP(97) AND INTERP(8)) after 1 ns;
  NAND22 : INTERP(29) <= NOT(fout,INTERP(14) AND INTERP(33)) after 1 ns;
  NAND23 : INTERP(95) <= NOT(fout,INTERP(38) AND INTERP(12)) after 1 ns;
  NAND24 : INTERP(107) <= NOT(fout,INTERP(44) AND INTERP(41)) after 1 ns;
  NAND25 : INTERP(45) <= NOT(fout,INTERP(40) AND INP(0)) after 1 ns;
  NAND26 : INTERP(108) <= NOT(fout,INTERP(51) AND INTERP(48)) after 1 ns;
  NAND27 : INTERP(52) <= NOT(fout,INTERP(47) AND INP(0)) after 1 ns;
  NAND28 : INTERP(103) <= NOT(fout,INTERP(98) AND INTERP(99) AND INTERP(109)) after 1 ns;
  NAND29 : INTERP(104) <= NOT(fout,INTERP(100) AND INTERP(101) AND INTERP(110)) after 1 ns;
  NOR16 : INTERP(5) <= NOT(fout,INTERP(67) OR INTERP(68)) after 1 ns;
  NOR17 : INTERP(76) <= NOT(fout,INTERP(93) OR INTERP(25) OR INTERP(26)) after 1 ns;
  NOR18 : INTERP(17) <= NOT(fout,INTERP(93) OR INTERP(24)) after 1 ns;
  NOR19 : INTERP(13) <= NOT(fout,INTERP(71) OR INTERP(72)) after 1 ns;
  NOR20 : INTERP(37) <= NOT(fout,INTERP(34) OR INTERP(75)) after 1 ns;
  NOR21 : INTERP(85) <= NOT(fout,INTERP(39) OR INTERP(40)) after 1 ns;
  NOR22 : INTERP(54) <= NOT(fout,INTERP(41) OR INTERP(45)) after 1 ns;
  NOR23 : INTERP(56) <= NOT(fout,INTERP(42) OR INTERP(107)) after 1 ns;
  NOR24 : INTERP(89) <= NOT(fout,INTERP(2) OR INTERP(107) OR INTERP(43)) after 1 ns;
  NOR25 : INTERP(78) <= NOT(fout,INTERP(0) OR INTERP(4) OR INTERP(2) OR INTERP(6)) after 1 ns;
  NOR26 : INTERP(79) <= NOT(fout,INTERP(46) OR INTERP(47)) after 1 ns;
  NOR27 : INTERP(80) <= NOT(fout,INTERP(48) OR INTERP(52)) after 1 ns;
  NOR28 : INTERP(81) <= NOT(fout,INTERP(49) OR INTERP(108)) after 1 ns;
  NOR29 : INTERP(83) <= NOT(fout,INTERP(10) OR INTERP(108) OR INTERP(50)) after 1 ns;
  NOR30 : INTERP(109) <= NOT(fout,INTERP(84) OR INTERP(86)) after 1 ns;
  NOR31 : INTERP(110) <= NOT(fout,INTERP(87) OR INTERP(88)) after 1 ns;
  BUFFER_OUT : OUTP <= OUTPI;

END rtl ;
