library IEEE;
use IEEE.std_logic_1164.all;
library selfext;
use work.gates_pkg.all;
use work.fflop_pkg.all;

ENTITY s298_bench IS
  PORT (
    INP: in std_ulogic_vector(0 to 2);
    OUTP : out std_ulogic_vector(0 to 5);
    H : in std_ulogic
  );
END s298_bench ;

ARCHITECTURE structural OF s298_bench IS
  signal INTERP : std_ulogic_vector(0 to 126):=(others=>'0') ;
  signal OUTPI : std_ulogic_vector(OUTP'range):=(others=>'0') ;
BEGIN
  DFF0 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(1),
      H => H,
      Q => INTERP(0));

  DFF1 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(3),
      H => H,
      Q => INTERP(2));

  DFF2 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(5),
      H => H,
      Q => INTERP(4));

  DFF3 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(7),
      H => H,
      Q => INTERP(6));

  DFF4 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(9),
      H => H,
      Q => INTERP(8));

  DFF5 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(11),
      H => H,
      Q => INTERP(10));

  DFF6 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(13),
      H => H,
      Q => INTERP(12));

  DFF7 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(15),
      H => H,
      Q => INTERP(14));

  DFF8 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(17),
      H => H,
      Q => INTERP(16));

  DFF9 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(19),
      H => H,
      Q => INTERP(18));

  DFF10 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(21),
      H => H,
      Q => INTERP(20));

  DFF11 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(23),
      H => H,
      Q => INTERP(22));

  DFF12 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(25),
      H => H,
      Q => INTERP(24));

  DFF13 : DFF generic map (1 ns,1 ns)
    port map (
      D => INTERP(27),
      H => H,
      Q => INTERP(26));

  INV0 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(29),
      out1 => INTERP(28));

  INV1 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(0),
      out1 => INTERP(30));

  INV2 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(6),
      out1 => INTERP(31));

  INV3 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(4),
      out1 => INTERP(32));

  INV4 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(2),
      out1 => INTERP(33));

  INV5 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(8),
      out1 => INTERP(34));

  INV6 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(26),
      out1 => INTERP(35));

  INV7 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(2),
      out1 => INTERP(36));

  INV8 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(6),
      out1 => INTERP(37));

  INV9 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(4),
      out1 => INTERP(38));

  INV10 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(24),
      out1 => INTERP(39));

  INV11 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(10),
      out1 => INTERP(40));

  INV12 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(12),
      out1 => INTERP(41));

  INV13 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(41),
      out1 => OUTPI(2));

  INV14 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(14),
      out1 => INTERP(42));

  INV15 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(42),
      out1 => OUTPI(5));

  INV16 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(0),
      out1 => INTERP(43));

  INV17 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(2),
      out1 => INTERP(44));

  INV18 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(12),
      out1 => INTERP(45));

  INV19 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(4),
      out1 => INTERP(46));

  INV20 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(14),
      out1 => INTERP(47));

  INV21 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(8),
      out1 => INTERP(48));

  INV22 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(16),
      out1 => INTERP(49));

  INV23 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(6),
      out1 => INTERP(50));

  INV24 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(52),
      out1 => INTERP(51));

  INV25 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(22),
      out1 => INTERP(53));

  INV26 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(16),
      out1 => INTERP(54));

  INV27 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(54),
      out1 => OUTPI(0));

  INV28 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(18),
      out1 => INTERP(55));

  INV29 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(55),
      out1 => OUTPI(3));

  INV30 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(57),
      out1 => INTERP(56));

  INV31 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(24),
      out1 => INTERP(58));

  INV32 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(2),
      out1 => INTERP(59));

  INV33 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(59),
      out1 => INTERP(57));

  INV34 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(61),
      out1 => INTERP(60));

  INV35 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(26),
      out1 => INTERP(62));

  INV36 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(0),
      out1 => INTERP(63));

  INV37 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(63),
      out1 => INTERP(29));

  INV38 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INP(1),
      out1 => INTERP(64));

  INV39 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(64),
      out1 => INTERP(61));

  INV40 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(20),
      out1 => INTERP(65));

  INV41 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(65),
      out1 => OUTPI(1));

  INV42 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(22),
      out1 => INTERP(66));

  INV43 : INVG generic map (1 ns,1 ns)
    port map (
      in1 => INTERP(66),
      out1 => OUTPI(4));

  AND0 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(28),
      inp(1) => INTERP(34),
      out1 => INTERP(67));

  AND1 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(35),
      inp(1) => INTERP(28),
      out1 => INTERP(68));

  AND2 : ANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(0),
      inp(1) => INTERP(32),
      inp(2) => INTERP(6),
      out1 => INTERP(69));

  AND3 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(0),
      inp(1) => INTERP(2),
      out1 => INTERP(70));

  AND4 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(30),
      inp(1) => INTERP(33),
      out1 => INTERP(71));

  AND5 : ANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(0),
      inp(1) => INTERP(2),
      inp(2) => INTERP(4),
      out1 => INTERP(72));

  AND6 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(30),
      inp(1) => INTERP(32),
      out1 => INTERP(73));

  AND7 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(33),
      inp(1) => INTERP(32),
      out1 => INTERP(74));

  AND8 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(31),
      inp(1) => INTERP(76),
      out1 => INTERP(75));

  AND9 : ANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(32),
      inp(1) => INTERP(33),
      inp(2) => INTERP(0),
      inp(3) => INTERP(78),
      out1 => INTERP(77));

  AND10 : ANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(34),
      inp(1) => INTERP(35),
      inp(2) => INTERP(80),
      out1 => INTERP(79));

  AND11 : ANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(38),
      inp(1) => INTERP(2),
      inp(2) => INTERP(39),
      inp(3) => INTERP(82),
      out1 => INTERP(81));

  AND12 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(40),
      inp(1) => INTERP(84),
      out1 => INTERP(83));

  AND13 : ANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(38),
      inp(1) => INTERP(2),
      inp(2) => INTERP(39),
      inp(3) => INTERP(82),
      out1 => INTERP(85));

  AND14 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(40),
      inp(1) => INTERP(84),
      out1 => INTERP(86));

  AND15 : ANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(4),
      inp(1) => INTERP(8),
      inp(2) => INTERP(18),
      out1 => INTERP(87));

  AND16 : ANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(44),
      inp(1) => INTERP(46),
      inp(2) => INTERP(8),
      out1 => INTERP(88));

  AND17 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(8),
      inp(1) => INTERP(45),
      out1 => INTERP(89));

  AND18 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(50),
      inp(1) => INTERP(48),
      out1 => INTERP(90));

  AND19 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(46),
      inp(1) => INTERP(50),
      out1 => INTERP(91));

  AND20 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(47),
      inp(1) => INTERP(6),
      out1 => INTERP(92));

  AND21 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(48),
      inp(1) => INTERP(6),
      out1 => INTERP(93));

  AND22 : ANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(49),
      inp(1) => INTERP(8),
      inp(2) => INTERP(4),
      out1 => INTERP(94));

  AND23 : ANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(50),
      inp(1) => INTERP(51),
      inp(2) => INTERP(96),
      out1 => INTERP(95));

  AND24 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(51),
      inp(1) => INTERP(98),
      out1 => INTERP(97));

  AND25 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(0),
      inp(1) => INTERP(52),
      out1 => INTERP(99));

  AND26 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(53),
      inp(1) => INTERP(8),
      out1 => INTERP(100));

  AND27 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(56),
      inp(1) => INTERP(58),
      out1 => INTERP(101));

  AND28 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(57),
      inp(1) => INTERP(24),
      out1 => INTERP(102));

  AND29 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(60),
      inp(1) => INTERP(62),
      out1 => INTERP(103));

  AND30 : ANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(61),
      inp(1) => INTERP(26),
      out1 => INTERP(104));

  OR0 : ORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(30),
      inp(1) => INTERP(33),
      inp(2) => INTERP(32),
      inp(3) => INTERP(31),
      out1 => INTERP(105));

  OR1 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(30),
      inp(1) => INTERP(2),
      inp(2) => INTERP(4),
      out1 => INTERP(106));

  OR2 : ORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(2),
      inp(1) => INTERP(4),
      inp(2) => INTERP(6),
      inp(3) => INTERP(48),
      out1 => INTERP(107));

  OR3 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(50),
      inp(1) => INTERP(16),
      out1 => INTERP(108));

  OR4 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(50),
      inp(1) => INTERP(8),
      out1 => INTERP(109));

  OR5 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(44),
      inp(1) => INTERP(4),
      inp(2) => INTERP(6),
      out1 => INTERP(110));

  OR6 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(46),
      inp(1) => INTERP(20),
      out1 => INTERP(111));

  OR7 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(50),
      inp(1) => INTERP(20),
      out1 => INTERP(112));

  OR8 : ORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(52),
      inp(1) => INTERP(50),
      inp(2) => INTERP(48),
      inp(3) => INTERP(18),
      out1 => INTERP(113));

  OR9 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(51),
      inp(1) => INTERP(43),
      out1 => INTERP(114));

  OR10 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(50),
      inp(1) => INTERP(8),
      out1 => INTERP(115));

  OR11 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(2),
      inp(1) => INTERP(8),
      out1 => INTERP(116));

  OR12 : ORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(4),
      inp(1) => INTERP(6),
      out1 => INTERP(117));

  OR13 : ORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(2),
      inp(1) => INTERP(4),
      inp(2) => INTERP(6),
      inp(3) => INTERP(48),
      out1 => INTERP(118));

  OR14 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(44),
      inp(1) => INTERP(46),
      inp(2) => INTERP(8),
      out1 => INTERP(119));

  OR15 : ORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(46),
      inp(1) => INTERP(48),
      inp(2) => INTERP(14),
      out1 => INTERP(120));

  NAND0 : NANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(4),
      inp(1) => INTERP(2),
      inp(2) => INTERP(0),
      out1 => INTERP(76));

  NAND1 : NANDG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(105),
      inp(1) => INTERP(106),
      inp(2) => INTERP(28),
      out1 => INTERP(121));

  NAND2 : NANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(6),
      inp(1) => INTERP(32),
      inp(2) => INTERP(33),
      inp(3) => INTERP(0),
      out1 => INTERP(80));

  NAND3 : NANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(38),
      inp(1) => INTERP(36),
      inp(2) => INTERP(24),
      inp(3) => INTERP(82),
      out1 => INTERP(84));

  NAND4 : NANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(118),
      inp(1) => INTERP(119),
      inp(2) => INTERP(120),
      inp(3) => INTERP(51),
      out1 => INTERP(122));

  NAND5 : NANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(107),
      inp(1) => INTERP(108),
      inp(2) => INTERP(109),
      inp(3) => INTERP(51),
      out1 => INTERP(123));

  NAND6 : NANDG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(113),
      inp(1) => INTERP(114),
      out1 => INTERP(124));

  NAND7 : NANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(110),
      inp(1) => INTERP(111),
      inp(2) => INTERP(112),
      inp(3) => INTERP(8),
      out1 => INTERP(98));

  NAND8 : NANDG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(115),
      inp(1) => INTERP(116),
      inp(2) => INTERP(117),
      inp(3) => INTERP(51),
      out1 => INTERP(125));

  NOR0 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(0),
      inp(1) => INTERP(29),
      out1 => INTERP(1));

  NOR1 : NORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(69),
      inp(1) => INTERP(70),
      inp(2) => INTERP(71),
      inp(3) => INTERP(29),
      out1 => INTERP(3));

  NOR2 : NORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(72),
      inp(1) => INTERP(73),
      inp(2) => INTERP(74),
      inp(3) => INTERP(29),
      out1 => INTERP(5));

  NOR3 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(75),
      inp(1) => INTERP(121),
      out1 => INTERP(7));

  NOR4 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(77),
      inp(1) => INTERP(79),
      inp(2) => INTERP(126),
      out1 => INTERP(9));

  NOR5 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(34),
      inp(1) => INTERP(31),
      out1 => INTERP(78));

  NOR6 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(67),
      inp(1) => INTERP(68),
      out1 => INTERP(126));

  NOR7 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(81),
      inp(1) => INTERP(83),
      inp(2) => INTERP(29),
      out1 => INTERP(11));

  NOR8 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(8),
      inp(1) => INTERP(37),
      out1 => INTERP(82));

  NOR9 : NORG_N generic map (4,1 ns,1 ns)
    port map (
      inp(0) => INTERP(89),
      inp(1) => INTERP(90),
      inp(2) => INTERP(91),
      inp(3) => INTERP(52),
      out1 => INTERP(13));

  NOR10 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(92),
      inp(1) => INTERP(93),
      inp(2) => INTERP(122),
      out1 => INTERP(15));

  NOR11 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(94),
      inp(1) => INTERP(123),
      out1 => INTERP(17));

  NOR12 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(95),
      inp(1) => INTERP(124),
      out1 => INTERP(19));

  NOR13 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(87),
      inp(1) => INTERP(88),
      out1 => INTERP(96));

  NOR14 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(97),
      inp(1) => INTERP(99),
      out1 => INTERP(21));

  NOR15 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(85),
      inp(1) => INTERP(86),
      out1 => INTERP(52));

  NOR16 : NORG_N generic map (2,1 ns,1 ns)
    port map (
      inp(0) => INTERP(100),
      inp(1) => INTERP(125),
      out1 => INTERP(23));

  NOR17 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(101),
      inp(1) => INTERP(102),
      inp(2) => INTERP(29),
      out1 => INTERP(25));

  NOR18 : NORG_N generic map (3,1 ns,1 ns)
    port map (
      inp(0) => INTERP(103),
      inp(1) => INTERP(104),
      inp(2) => INTERP(29),
      out1 => INTERP(27));

  BUFFER_OUT : OUTP <= OUTPI;

END structural ;

ARCHITECTURE rtl OF s298_bench IS
  signal INTERP : std_ulogic_vector(0 to 126):=(others=>'0') ;
  signal OUTPI : std_ulogic_vector(OUTP'range):=(others=>'0') ;
BEGIN
  REGVECT : BLOCK (H='1' AND NOT H'STABLE)
    BEGIN
      DFF14 : INTERP(0) <= GUARDED INTERP(1) after 1 ns;
      DFF15 : INTERP(2) <= GUARDED INTERP(3) after 1 ns;
      DFF16 : INTERP(4) <= GUARDED INTERP(5) after 1 ns;
      DFF17 : INTERP(6) <= GUARDED INTERP(7) after 1 ns;
      DFF18 : INTERP(8) <= GUARDED INTERP(9) after 1 ns;
      DFF19 : INTERP(10) <= GUARDED INTERP(11) after 1 ns;
      DFF20 : INTERP(12) <= GUARDED INTERP(13) after 1 ns;
      DFF21 : INTERP(14) <= GUARDED INTERP(15) after 1 ns;
      DFF22 : INTERP(16) <= GUARDED INTERP(17) after 1 ns;
      DFF23 : INTERP(18) <= GUARDED INTERP(19) after 1 ns;
      DFF24 : INTERP(20) <= GUARDED INTERP(21) after 1 ns;
      DFF25 : INTERP(22) <= GUARDED INTERP(23) after 1 ns;
      DFF26 : INTERP(24) <= GUARDED INTERP(25) after 1 ns;
      DFF27 : INTERP(26) <= GUARDED INTERP(27) after 1 ns;
    END BLOCK ;
  INV44 : INTERP(28) <= NOT(fout,INTERP(29)) after 1 ns;
  INV45 : INTERP(30) <= NOT(fout,INTERP(0)) after 1 ns;
  INV46 : INTERP(31) <= NOT(fout,INTERP(6)) after 1 ns;
  INV47 : INTERP(32) <= NOT(fout,INTERP(4)) after 1 ns;
  INV48 : INTERP(33) <= NOT(fout,INTERP(2)) after 1 ns;
  INV49 : INTERP(34) <= NOT(fout,INTERP(8)) after 1 ns;
  INV50 : INTERP(35) <= NOT(fout,INTERP(26)) after 1 ns;
  INV51 : INTERP(36) <= NOT(fout,INTERP(2)) after 1 ns;
  INV52 : INTERP(37) <= NOT(fout,INTERP(6)) after 1 ns;
  INV53 : INTERP(38) <= NOT(fout,INTERP(4)) after 1 ns;
  INV54 : INTERP(39) <= NOT(fout,INTERP(24)) after 1 ns;
  INV55 : INTERP(40) <= NOT(fout,INTERP(10)) after 1 ns;
  INV56 : INTERP(41) <= NOT(fout,INTERP(12)) after 1 ns;
  INV57 : OUTPI(2) <= NOT(fout,INTERP(41)) after 1 ns;
  INV58 : INTERP(42) <= NOT(fout,INTERP(14)) after 1 ns;
  INV59 : OUTPI(5) <= NOT(fout,INTERP(42)) after 1 ns;
  INV60 : INTERP(43) <= NOT(fout,INTERP(0)) after 1 ns;
  INV61 : INTERP(44) <= NOT(fout,INTERP(2)) after 1 ns;
  INV62 : INTERP(45) <= NOT(fout,INTERP(12)) after 1 ns;
  INV63 : INTERP(46) <= NOT(fout,INTERP(4)) after 1 ns;
  INV64 : INTERP(47) <= NOT(fout,INTERP(14)) after 1 ns;
  INV65 : INTERP(48) <= NOT(fout,INTERP(8)) after 1 ns;
  INV66 : INTERP(49) <= NOT(fout,INTERP(16)) after 1 ns;
  INV67 : INTERP(50) <= NOT(fout,INTERP(6)) after 1 ns;
  INV68 : INTERP(51) <= NOT(fout,INTERP(52)) after 1 ns;
  INV69 : INTERP(53) <= NOT(fout,INTERP(22)) after 1 ns;
  INV70 : INTERP(54) <= NOT(fout,INTERP(16)) after 1 ns;
  INV71 : OUTPI(0) <= NOT(fout,INTERP(54)) after 1 ns;
  INV72 : INTERP(55) <= NOT(fout,INTERP(18)) after 1 ns;
  INV73 : OUTPI(3) <= NOT(fout,INTERP(55)) after 1 ns;
  INV74 : INTERP(56) <= NOT(fout,INTERP(57)) after 1 ns;
  INV75 : INTERP(58) <= NOT(fout,INTERP(24)) after 1 ns;
  INV76 : INTERP(59) <= NOT(fout,INP(2)) after 1 ns;
  INV77 : INTERP(57) <= NOT(fout,INTERP(59)) after 1 ns;
  INV78 : INTERP(60) <= NOT(fout,INTERP(61)) after 1 ns;
  INV79 : INTERP(62) <= NOT(fout,INTERP(26)) after 1 ns;
  INV80 : INTERP(63) <= NOT(fout,INP(0)) after 1 ns;
  INV81 : INTERP(29) <= NOT(fout,INTERP(63)) after 1 ns;
  INV82 : INTERP(64) <= NOT(fout,INP(1)) after 1 ns;
  INV83 : INTERP(61) <= NOT(fout,INTERP(64)) after 1 ns;
  INV84 : INTERP(65) <= NOT(fout,INTERP(20)) after 1 ns;
  INV85 : OUTPI(1) <= NOT(fout,INTERP(65)) after 1 ns;
  INV86 : INTERP(66) <= NOT(fout,INTERP(22)) after 1 ns;
  INV87 : OUTPI(4) <= NOT(fout,INTERP(66)) after 1 ns;
  AND31 : INTERP(67) <= INTERP(28) AND INTERP(34) after 1 ns;
  AND32 : INTERP(68) <= INTERP(35) AND INTERP(28) after 1 ns;
  AND33 : INTERP(69) <= INTERP(0) AND INTERP(32) AND INTERP(6) after 1 ns;
  AND34 : INTERP(70) <= INTERP(0) AND INTERP(2) after 1 ns;
  AND35 : INTERP(71) <= INTERP(30) AND INTERP(33) after 1 ns;
  AND36 : INTERP(72) <= INTERP(0) AND INTERP(2) AND INTERP(4) after 1 ns;
  AND37 : INTERP(73) <= INTERP(30) AND INTERP(32) after 1 ns;
  AND38 : INTERP(74) <= INTERP(33) AND INTERP(32) after 1 ns;
  AND39 : INTERP(75) <= INTERP(31) AND INTERP(76) after 1 ns;
  AND40 : INTERP(77) <= INTERP(32) AND INTERP(33) AND INTERP(0) AND INTERP(78) after 1 ns;
  AND41 : INTERP(79) <= INTERP(34) AND INTERP(35) AND INTERP(80) after 1 ns;
  AND42 : INTERP(81) <= INTERP(38) AND INTERP(2) AND INTERP(39) AND INTERP(82) after 1 ns;
  AND43 : INTERP(83) <= INTERP(40) AND INTERP(84) after 1 ns;
  AND44 : INTERP(85) <= INTERP(38) AND INTERP(2) AND INTERP(39) AND INTERP(82) after 1 ns;
  AND45 : INTERP(86) <= INTERP(40) AND INTERP(84) after 1 ns;
  AND46 : INTERP(87) <= INTERP(4) AND INTERP(8) AND INTERP(18) after 1 ns;
  AND47 : INTERP(88) <= INTERP(44) AND INTERP(46) AND INTERP(8) after 1 ns;
  AND48 : INTERP(89) <= INTERP(8) AND INTERP(45) after 1 ns;
  AND49 : INTERP(90) <= INTERP(50) AND INTERP(48) after 1 ns;
  AND50 : INTERP(91) <= INTERP(46) AND INTERP(50) after 1 ns;
  AND51 : INTERP(92) <= INTERP(47) AND INTERP(6) after 1 ns;
  AND52 : INTERP(93) <= INTERP(48) AND INTERP(6) after 1 ns;
  AND53 : INTERP(94) <= INTERP(49) AND INTERP(8) AND INTERP(4) after 1 ns;
  AND54 : INTERP(95) <= INTERP(50) AND INTERP(51) AND INTERP(96) after 1 ns;
  AND55 : INTERP(97) <= INTERP(51) AND INTERP(98) after 1 ns;
  AND56 : INTERP(99) <= INTERP(0) AND INTERP(52) after 1 ns;
  AND57 : INTERP(100) <= INTERP(53) AND INTERP(8) after 1 ns;
  AND58 : INTERP(101) <= INTERP(56) AND INTERP(58) after 1 ns;
  AND59 : INTERP(102) <= INTERP(57) AND INTERP(24) after 1 ns;
  AND60 : INTERP(103) <= INTERP(60) AND INTERP(62) after 1 ns;
  AND61 : INTERP(104) <= INTERP(61) AND INTERP(26) after 1 ns;
  OR16 : INTERP(105) <= INTERP(30) OR INTERP(33) OR INTERP(32) OR INTERP(31) after 1 ns;
  OR17 : INTERP(106) <= INTERP(30) OR INTERP(2) OR INTERP(4) after 1 ns;
  OR18 : INTERP(107) <= INTERP(2) OR INTERP(4) OR INTERP(6) OR INTERP(48) after 1 ns;
  OR19 : INTERP(108) <= INTERP(50) OR INTERP(16) after 1 ns;
  OR20 : INTERP(109) <= INTERP(50) OR INTERP(8) after 1 ns;
  OR21 : INTERP(110) <= INTERP(44) OR INTERP(4) OR INTERP(6) after 1 ns;
  OR22 : INTERP(111) <= INTERP(46) OR INTERP(20) after 1 ns;
  OR23 : INTERP(112) <= INTERP(50) OR INTERP(20) after 1 ns;
  OR24 : INTERP(113) <= INTERP(52) OR INTERP(50) OR INTERP(48) OR INTERP(18) after 1 ns;
  OR25 : INTERP(114) <= INTERP(51) OR INTERP(43) after 1 ns;
  OR26 : INTERP(115) <= INTERP(50) OR INTERP(8) after 1 ns;
  OR27 : INTERP(116) <= INTERP(2) OR INTERP(8) after 1 ns;
  OR28 : INTERP(117) <= INTERP(4) OR INTERP(6) after 1 ns;
  OR29 : INTERP(118) <= INTERP(2) OR INTERP(4) OR INTERP(6) OR INTERP(48) after 1 ns;
  OR30 : INTERP(119) <= INTERP(44) OR INTERP(46) OR INTERP(8) after 1 ns;
  OR31 : INTERP(120) <= INTERP(46) OR INTERP(48) OR INTERP(14) after 1 ns;
  NAND9 : INTERP(76) <= NOT(fout,INTERP(4) AND INTERP(2) AND INTERP(0)) after 1 ns;
  NAND10 : INTERP(121) <= NOT(fout,INTERP(105) AND INTERP(106) AND INTERP(28)) after 1 ns;
  NAND11 : INTERP(80) <= NOT(fout,INTERP(6) AND INTERP(32) AND INTERP(33) AND INTERP(0)) after 1 ns;
  NAND12 : INTERP(84) <= NOT(fout,INTERP(38) AND INTERP(36) AND INTERP(24) AND INTERP(82)) after 1 ns;
  NAND13 : INTERP(122) <= NOT(fout,INTERP(118) AND INTERP(119) AND INTERP(120) AND INTERP(51)) after 1 ns;
  NAND14 : INTERP(123) <= NOT(fout,INTERP(107) AND INTERP(108) AND INTERP(109) AND INTERP(51)) after 1 ns;
  NAND15 : INTERP(124) <= NOT(fout,INTERP(113) AND INTERP(114)) after 1 ns;
  NAND16 : INTERP(98) <= NOT(fout,INTERP(110) AND INTERP(111) AND INTERP(112) AND INTERP(8)) after 1 ns;
  NAND17 : INTERP(125) <= NOT(fout,INTERP(115) AND INTERP(116) AND INTERP(117) AND INTERP(51)) after 1 ns;
  NOR19 : INTERP(1) <= NOT(fout,INTERP(0) OR INTERP(29)) after 1 ns;
  NOR20 : INTERP(3) <= NOT(fout,INTERP(69) OR INTERP(70) OR INTERP(71) OR INTERP(29)) after 1 ns;
  NOR21 : INTERP(5) <= NOT(fout,INTERP(72) OR INTERP(73) OR INTERP(74) OR INTERP(29)) after 1 ns;
  NOR22 : INTERP(7) <= NOT(fout,INTERP(75) OR INTERP(121)) after 1 ns;
  NOR23 : INTERP(9) <= NOT(fout,INTERP(77) OR INTERP(79) OR INTERP(126)) after 1 ns;
  NOR24 : INTERP(78) <= NOT(fout,INTERP(34) OR INTERP(31)) after 1 ns;
  NOR25 : INTERP(126) <= NOT(fout,INTERP(67) OR INTERP(68)) after 1 ns;
  NOR26 : INTERP(11) <= NOT(fout,INTERP(81) OR INTERP(83) OR INTERP(29)) after 1 ns;
  NOR27 : INTERP(82) <= NOT(fout,INTERP(8) OR INTERP(37)) after 1 ns;
  NOR28 : INTERP(13) <= NOT(fout,INTERP(89) OR INTERP(90) OR INTERP(91) OR INTERP(52)) after 1 ns;
  NOR29 : INTERP(15) <= NOT(fout,INTERP(92) OR INTERP(93) OR INTERP(122)) after 1 ns;
  NOR30 : INTERP(17) <= NOT(fout,INTERP(94) OR INTERP(123)) after 1 ns;
  NOR31 : INTERP(19) <= NOT(fout,INTERP(95) OR INTERP(124)) after 1 ns;
  NOR32 : INTERP(96) <= NOT(fout,INTERP(87) OR INTERP(88)) after 1 ns;
  NOR33 : INTERP(21) <= NOT(fout,INTERP(97) OR INTERP(99)) after 1 ns;
  NOR34 : INTERP(52) <= NOT(fout,INTERP(85) OR INTERP(86)) after 1 ns;
  NOR35 : INTERP(23) <= NOT(fout,INTERP(100) OR INTERP(125)) after 1 ns;
  NOR36 : INTERP(25) <= NOT(fout,INTERP(101) OR INTERP(102) OR INTERP(29)) after 1 ns;
  NOR37 : INTERP(27) <= NOT(fout,INTERP(103) OR INTERP(104) OR INTERP(29)) after 1 ns;
  BUFFER_OUT : OUTP <= OUTPI;

END rtl ;
