
------------------------------------------------------------------------
-- DFFC flip-flop
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity DFFC is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (D,H,C : std_logic := '0';
          Q      : out std_logic := '0');
end DFFC;

architecture BEH of DFFC is
begin

    p1: process(H)
        variable ex_value,val : std_logic := '0';
    begin

        -- test du front montant
        
        if (H='1' and  H'last_value='0') then
        
          if (C='0') then  
            val := '0';
          else
            val := D; 
          end if;
           
          if (ex_value /= val) then
            ex_value := val;
            case val is
              when '0' =>
                Q <= '0' after tpd_hl;
              when '1' =>
                Q <= '1' after tpd_lh;
              when others =>
                Q <= val;
            end case;   
          end if;
        end if;  
    end process;

end BEH;


------------------------------------------------------------------------
-- DFF flip-flop
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity DFF is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (D,H : in std_logic := '0';
          Q   : out std_logic :='0');  
end DFF;

architecture BEH of DFF is
begin

    p1: process(H)
        variable ex_value,val : std_logic := '0';
    begin

        -- test du front montant
        
        if (H='1' and  H'last_value='0') then
        
          val := D; 
           
          if (ex_value /= val) then
            ex_value := val;
            case val is
              when '0' =>
                Q <= '0' after tpd_hl;
              when '1' =>
                Q <= '1' after tpd_lh;
              when others =>
                Q <= val;
           end case;   
          end if;
        end if;  
    end process;

end BEH;


------------------------------------------------------------------------
-- TFFC flip-flop
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity TFFC is
    generic (tpd_hl : time := 1 ns;
             tpd_lh : time := 1 ns);
    port (T,H,C : std_logic := '0';
          Q      : out std_logic := '0');
end TFFC;

architecture BEH of TFFC is
begin

    p1: process(H)
        variable ex_value : std_logic := '0';
    begin

        -- test du front montant
        
        if (H='1' and  H'last_value='0') then
        
          if (C='0') then  
            if (ex_value='1') then
              Q <= '0' after tpd_hl;
            end if;
          else
            if T ='1' then
              ex_value:=not(ex_value);
              case ex_value is
                when '0' =>
                  Q <= '1' after tpd_lh;
                when '1' =>
                  Q <= '0' after tpd_hl;
                when others =>
              end case;   
            end if;
          end if;  
        end if;
    end process;

end BEH;
