-- test bench that shows the different behaviors in order for 
-- the multiplexers when s='X' 
library IEEE;
use IEEE.std_logic_1164.all;

entity tbench is 
end entity tbench; 

architecture prova of tbench is 
signal d0,d1,s,out_sp,out_sp_r,out_ps: std_logic; 
begin 

  m0: entity work.multiplexer(dflow_sp) generic map (2 ns) 
      port map (d0,s,d1,out_sp); 
  m1: entity work.multiplexer(dflow_sp_r) generic map (2 ns) 
      port map (d0,s,d1,out_sp_r);          
  m2: entity work.multiplexer(dflow_ps) generic map (2 ns) 
      port map (d0,s,d1,out_ps);
      
  process 
  begin 
    wait for 5 ns; 
    d0 <= '1';
    d1 <= '1';
    s <= '1'; 
    wait for 5 ns; 
    s <= 'X'; -- note the different outputs 
    wait for 5 ns; 
    d0 <= '0'; -- note the different outputs 
    d1 <= '0';
    wait for 5 ns;
    wait;
end process; 
end architecture; 
