-- three data flow architectures of a multiplexer 
-- they are equivalent from the Boolean point of view 
-- but not from the point of view of std_logic 
-- their behavior in the presence of 'X' values of s 
-- is different; in particular, 'X' output values are 
-- produced when s='X' and the the data inputs have the same value 
-- this is called pessimism because the circuit would produce the 
-- value of the input as output forn any value of s 
library IEEE;
use IEEE.std_logic_1164.all;

entity multilexer is 
generic (d: time); 
port(d0,s,d1: in std_logic;
     x: out std_logic); 
end entity; 

-- SP expression irredundant 
architecture dflow_sp of multiplexer is 
begin 
  x <= (d0 and not(s)) or (d1 and s) after d; 
end architecture; 

-- SP expression redundant (by using consensus) 
architecture dflow_sp_r of multiplexer is 
begin 
  x <= (d0 and not(s)) or (d1 and s) or (d0 and d1) after d; 
end architecture; 

-- PS expression irredundant 
architecture dflow_ps of multiplexer is 
begin
  x <= (d0 or s) and (d1 or not(s)) after d; 
end architecture; 
