      
-- modello di gate or a due ingressi con semplice ritardo di propagazione 
-- vengono fornite tre architetture per la stessa entity con il modello di 
-- ritardo di tipo inerziale, quello di tipo trasporto e quello di tipo 
-- inerziale con ritardo differenziato 

library IEEE;
use IEEE.std_logic_1164.all;

entity or2 is 
generic (t,tr: time); 
port (a,b: in std_logic; 
      output: out std_logic); 
end entity;   

-- inertial delay 
architecture inertial_delay of or2 is 
begin 
  output <= a or b after t;
end architecture; 

-- transport delay 
architecture transport_delay of or2 is 
begin 
  output <= transport a or b after t; 
end architecture;   

-- inertial with reject 
architecture inertial_delay_r of or2 is 
begin 
  output <= reject tr inertial a or b after t; 
end architecture; 
