library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 

entity device is 
port (a,n: in std_logic_vector(3 downto 0); 
      start: in std_logic; 
      s: out std_logic_vector(7 downto 0); 
      dr,ovflw: out std_logic;
      clk: in std_logic); 
end entity device; 

architecture behav of device is 
type state_type is (idle,init,testloop,testovflw,loopbody,ovflwbody,results); 
signal present_state, next_state: state_type;
signal x:std_logic_vector(8 downto 0); 
signal y:std_logic_vector(7 downto 0); 
signal w: integer; 
begin 
p0: process(clk) 
begin 
  if ((clk='1') and (clk'last_value='0')) then 
    present_state <= next_state; 
  end if; 
end process p0; 
p1: process(start,present_state) 
variable dat: std_logic_vector(7 downto 0); 
variable sum: unsigned(8 downto 0); 
variable nloop: std_logic_vector(3 downto 0);  
variable i: integer; 
begin 
  dr<='0'; 
  ovflw<='0';
  x<=std_logic_vector(sum); 
  y<=dat; 
  w<=i; 
  s<=std_logic_vector(sum(7 downto 0));  
  case present_state is 
  when idle => if (start='0') then 
                 next_state<=idle; 
               elsif (start='1') then 
                    next_state<=init; 
               end if;  
  when init => i:=0; 
               sum:=(others =>'0'); 
               dat:="0000" & a;
               nloop:=n; 
               next_state<=testloop; 
  when testloop => if (i<unsigned(nloop)) then
                     next_state<=loopbody; 
                   else 
                     next_state<=results;
                   end if;  
  when loopbody => sum:=sum+unsigned(dat);
                   dat:=to_stdlogicvector(to_bitvector(dat) sll 1); 
                   i:=i+1; 
                   next_state<=testovflw; 
  when testovflw => if (sum(8)='1') then 
                      next_state<=ovflwbody; 
                    elsif (sum(8)='0') then 
                      next_state<=testloop; 
                    end if; 
  when ovflwbody => dr<='1'; 
                    ovflw<='1'; 
                    next_state<=idle; 
  when results => dr<='1'; 
                  next_state<=idle; 
  end case; 
end process p1; 

end architecture behav;  
                

